﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.BaseAndInterface;
using Tools;

namespace ModelData.BusinessModel.ExtraEntities
{
    /// \addtogroup Entities
    /// @{

    /// \class  Founder
    ///
    /// \brief  Отражает сущность основателя поселения Помимо наследуемых свойств, описывает
    ///         дополнительную информацию об основателе.
    ///
    /// \author Denis
    /// \date   30.03.2019

    public class Source : I_MySerializable
    {
        /// \property   public string Title
        ///
        /// \brief  Нименование источника.
        /// Установлен атрибут IndexAttrib со значением 0
        /// \returns    The Title.

        [IndexAttrib(0)] public string Title { set; get; }



        /// \property   public List<string> Name
        ///
        /// \brief  Ссылки на источник в вебе.
        /// Установлен атрибут IndexAttrib со значением 1
        /// \returns    The URLs.

        [IndexAttrib(2)] public List<string> URLs { set; get; }


        /// \property   public string Title
        ///
        /// \brief  Нименование источника.
        /// Установлен атрибут IndexAttrib со значением 0
        /// \returns    The Title.

        [IndexAttrib(3)] public string Auther { set; get; }



        /// \fn public override Dictionary<string, string> Serialize()
        ///
        /// \brief  Метод записи данных о сущности в Dictionary.
        ///
        /// \author Denis
        /// \date   30.03.2019
        ///
        /// \returns    A Dictionary&lt;string,string&gt;

        public Dictionary<string, string> Serialize()
        {
            string r = "";
            if (URLs != null)
                foreach (string s in URLs)
                    if (s != null && s != "")
                        r += s;

            return new Dictionary<string, string>()
            {               
                ["Название"] = this.Title ?? "",
                ["URL"] = r,
                ["Автор"] = this.Auther ?? ""
            };
        }
    }


    /// @}
}
