﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel.Tools
{
    /// \addtogroup Entities
    /// @{

    /// \class  Period
    ///
    /// \brief  Сущность временного периода
    /// Изначально был запланирован согласно онтологической модели.
    /// Пока не используется.
    /// \author Denis
    /// \date   31.03.2019

    public class Period
    {
        /// \property   public InstantTime Begin
        ///
        /// \brief  Точный год начала периода
        ///
        /// \returns    The begin.

        public InstantTime Begin { set; get; }



        /// \property   public InstantTime End
        ///
        /// \brief  Точный год окончания периода
        ///
        /// \returns    The end.

        public InstantTime End { set; get; }

        /// \fn public override string ToString()
        ///
        /// \brief  Возвращает строку, представляющую текущий объект.
        /// Будучи базовой сущностью (не унаследованной от BaseOntologyEntity) требует преобразования в строку.
        /// \author Denis
        /// \date   31.03.2019
        ///
        /// \returns    Строка, представляющая текущий объект.

        public override string ToString()
        {
            return Begin + " : " + End;
        }
    }

    /// @}
}
