﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//using OfficeOpenXml;
using Xceed.Words.NET;

namespace Tools.Word
{
    public class DocXWrite
    {
        public System.IO.Stream EntitysToDocx(IEnumerable<object> d)
        {
            return new System.IO.MemoryStream();
        }

        //public static DocX GetDocX(List<I_MySerializable> list, out System.IO.MemoryStream wr)
        //{
        //    wr = new System.IO.MemoryStream();
        //    DocX doc = DocX.Create(wr);
        //    foreach (var elem in list)
        //        Serialize(elem, doc);
        //    return doc;           
        //}

        //public static DocX GetDocX(I_MySerializable elem, out System.IO.MemoryStream wr)
        //{
        //    wr = new System.IO.MemoryStream();
        //    DocX doc = DocX.Create(wr);
        //    Serialize(elem, doc);

        //    return doc;
        //}

        public static void PrintDocX(IEnumerable<I_MySerializable> list, out System.IO.MemoryStream wr, string path = null)
        {
            wr = new System.IO.MemoryStream();
            DocX doc = DocX.Create(wr);
            foreach (var elem in list)
                Serialize(elem, doc);

            doc.Save();
            wr.Position = 0;
            if (path != null && path != "")
                doc.SaveAs(path);
            wr.Position = 0;
        }

        public static void PrintDocX(I_MySerializable elem, out System.IO.MemoryStream wr, string path = null)
        {
            wr = new System.IO.MemoryStream();
            DocX doc = DocX.Create(wr);
            Serialize(elem, doc);
            doc.Save();
            wr.Position = 0;
            if (path != null && path != "")
                doc.SaveAs(path);
            wr.Position = 0;
        }

        private static void Serialize(I_MySerializable obj, DocX doc)
        {
            var serialize = obj.Serialize();
            foreach (var elem in serialize)
                if (elem.Value != null && elem.Value != "")
                    doc.InsertParagraph(elem.Key + " : " + elem.Value);
        }
    }
}
