﻿ymaps.ready(MapInit);

function MapInit()
{
    console.log("MapInit");
    CollectionsInit();
    YandexMapInit();
    GetDate(true);    
}

var Collections;

var Map;
var CurrentZoom;
var MinYear;
var MaxYear;
var CurrentMinYear;
var CurrentMaxYear;

//  Функция загрузки Яндекс карты
function YandexMapInit()
{
    Map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 8,
            type: 'yandex#satellite'/*'yandex#hybrid'*/,
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: Collections.MapArea
            // !!! используется значение [[48.795, 41.484], [53.823, 51.856]]

            //  это старые, уже не помню зачем их сохраняю
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
    );
    CurrentZoom = Map.action.getCurrentState().zoom;
    Map.controls.get('zoomControl').options.set({ size: 'auto' });
    Map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite'/*, 'yandex#hybrid'*/]));

    // Будем отслеживать зум карты при смене видимых границ (движение карты и смена zoom)
    Map.events.add('boundschange', function (event)
    {
        SelectDataFromArrays();
    });

    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#c3c3c3',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            Map.geoObjects.add(background);
        });
}

//  Функция создания слайдера дат и обработчик поля ввода дат
function SliderInit() {
    var slider = $("#slider").rangeSlider({
        bounds: { min: MinYear, max: MaxYear },
        defaultValues: { min: CurrentMinYear, max: CurrentMaxYear },
        arrows: true,
        symmetricPositionning: true,
        step: 1
    });
    //"valuesChanged" для ручного и машинного изменения
    //"userValuesChanged" для ручного изменения
    $("#slider").bind("valuesChanged", function (e, data) {
        SliderOnFinishMoving(data.values);
    });   

    //  Поле ввода меньшей даты. Обработчик изменения дат слайдера
    var inputFieldMinYear = document.getElementById('inputMinYear');
    inputFieldMinYear.oninput = function () {
        if (inputFieldMinYear.value <= MaxYear && inputFieldMinYear.value >= MinYear) {
            $("#slider").rangeSlider("values", inputFieldMinYear.value - 0, $("#slider").rangeSlider("values").max);
        }
    };

    //  Поле ввода большей даты. Обработчик изменения дат слайдера
    var inputFieldMaxYear = document.getElementById('inputMaxYear');
    inputFieldMaxYear.oninput = function () {
        if (inputFieldMaxYear.value <= MaxYear && inputFieldMaxYear.value >= MinYear) {
            $("#slider").rangeSlider("values", $("#slider").rangeSlider("values").min, inputFieldMaxYear.value - 0);
        }
    };

    //  Обработчик кнопки поиска по имени
    $('#buttonSearch').bind('click', function () {
        var resultName = document.getElementById('inputName').value;
        if (resultName.length != 0)
            OnFindNameUsing(resultName);
    });

    //  Обработчик кнопки сокрытия левой боковой панели
    $('#sidebar-left-close').bind('click', function () {
        $('#sidebar-left, #content').addClass('active');
        $('.collapse.in').toggleClass('in');
        $('a[aria-expanded=true]').attr('aria-expanded', 'false');
    });

    //  Обработчик кнопки лобавления поселения в экспорт
    $('#add-to-export-group').bind('click', addToExport);

    //  Обработчик кнопки сокрытия правой боковой панели
    $('#sidebar-right-close').bind('click', CloseRightPanel);

    // Кнопка открытия правой боковой панели для экспорта
    $('#sidebar-right-export').bind('click', exportSidebarButton);

    // Кнопка открытия правой боковой панели для импорта
    $('#sidebar-right-import').bind('click', function () {
        //  вызов отрисовки формы создания нового поселения
        printImportAddingForm();
        //  вызов появления панели
        importSidebarButton();
    });

    // Кнопка открытия правой боковой панели для импорта
    $('#addEditInfo').bind('click', function () {
        //  вызов отрисовки формы создания нового ИЗМЕНЕННОГО поселения
        printImportEditingForm();
        //  вызов появления панели
        importSidebarButton();
    });   
    
    // Кнопка экспорта в word
    $('#export-to-word').bind('click', function () {
        if (Collections.Export != null && Collections.Export.length > 0) {            
            ExportData('word');
        }
            
    });

    // Кнопка экспорта в excel
    $('#export-to-excel').bind('click', function () {
        if (Collections.Export != null && Collections.Export.length > 0) {
            ExportData('excel');
        }
    });   

    //  Отправка формы импорта данных
    $("#import-form").submit(function (e) {
        e.preventDefault();
        var content = '';
        var form = $('#import-form, #content');
        if (form.hasClass('edited-import')) {
            content = 'edited-import';
        }
        else if (form.hasClass('origin-import')) {
            content = 'origin-import';
        }
        importFormSubmit(content);
    });
}

function AutoCompleteInit(data) {
    $('input#inputName').autocomplete({
        source: function (request, response) {
            var term = request.term;
            var pattern = new RegExp("^" + term, "i");

            var results = $.map(data, function (elem) {
                if (pattern.test(elem)) {
                    return elem;
                }
            })
            response(results.slice(0, 10));
        },
        minLength: 2,
        delay: 300,
        select: function(event, ui) {
            OnFindNameUsing(ui.item.value)
        }
    });}

function filterCollectionInit(filterCollection, fromData, groupID, header) {
    var template = '<li class="list-group-item p-0"><div class="input-group"><div class="input-group-prepend"><div class="input-group-text"><input type="checkbox" checked onchange="FUNC(this)"></div></div><span class="form-control" data-toggle="tooltip" data-placement="top" title="NAME">NAME</span></div></li>';
    if (groupID == 'filterGroupTypes') {
        template = template.replace(/FUNC/g, 'filterTypeChange')
    }
    else if (groupID == 'filterGroupRegions'){
        template = template.replace(/FUNC/g, 'filterRegionChange')
    }
    var text = '';
    fromData.forEach(function (element) {
        filterCollection[element] = true;
        text += template.replace(/NAME/g, element);
    });
    $('#' + header)[0].innerHTML = fromData.length;
    $('#' + groupID)[0].innerHTML = text;
}

//  Функция создания коллекций Яндекс-объектов
function CollectionsInit() {
    //  Набор массивов, которые формируются для более гибкого отображения данных на странице.
    //  Являются параметрами глобальной переменной-объекта.

    Collections = new Object();
    Collections.All = new Array();
    Collections.AllGeoObjects = new ymaps.geoQuery();
    Collections.SettlementTypes = new Array();
    Collections.Regions = new Array();
    Collections.FindName = '';
    Collections.VisibleCount = 50;
    Collections.Names = new Array();
    Collections.Export = new Array();
    Collections.CurrentSettlement = new Object();
    Collections.Filters = new Object();
    Collections.Filters.Type = new Object();
    Collections.Filters.Region = new Object();
    Collections.isNeedFilters = false;
    Collections.MapArea = [[48.795, 41.484], [53.823, 51.856]];

    //  Эти коллекции нужно обнулять, но т.к. нет внесения новых данных о них, то пусть будут статичными
    Collections.AllSettlementTypes = new Array();
    Collections.AllRegions = new Array();
}