﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.IO;

using ModelData.WebModel;
using Tools.Word;

namespace web_map.Controllers
{
    public class MapController : BaseController
    {
        // GET: Map
        public ActionResult Map()
        {
            return View();
        }

        public FileResult ExportInfo(string data, string type)
        {
            //WebDataManager webData = WebDataManager.Get();
            var inputList = data.Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries).ToList<string>();
            var infoList = new List<ModelData.BusinessModel.MainEntities.Settlement>(inputList.Count);

            WebDataManager webData = WebDataManager.Get();
            foreach (var item in inputList)
                infoList.Add(webData.GetSettlement(item));

            DocXWrite.PrintDocX(infoList, out MemoryStream mr);

            string file_name = "info.docx";

            return File(mr, System.Net.Mime.MediaTypeNames.Application.Octet, file_name);
        }

        [HttpPost]
        public JsonResult ImportForm(string formData, string type)
        {
            WebDataManager webData = WebDataManager.Get();

            var inputArray = formData.Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries);
            Dictionary<string, string> form = new Dictionary<string, string>();
            string key, value;
            foreach (var elem in inputArray)
            {
                key = elem.Split('~')[0];
                value = elem.Split('~')[1];
                if (value == "null" || value == null)
                    value = "";
                form.Add(key, value);
            }

            return Json("Import success", JsonRequestBehavior.AllowGet);
        }

        [HttpGet]
        public JsonResult GetAllOfType(string type)
        {
            WebDataManager webData = WebDataManager.Get();
            if (type == "type")
            {
                return Json(webData.GetAllSettlementTypes(), JsonRequestBehavior.AllowGet);
            }
            else if (type == "region")
            {
                return Json(webData.GetAllRegions(), JsonRequestBehavior.AllowGet);
            }
            else
                return Json(""/*webData.GetSettlementsNames(type)*/, JsonRequestBehavior.AllowGet);
        }
    }
}