﻿//  Функция выводит данные о поселении в боковую панель из JSON объекта
function PrintInfoAboutSettlement(info)
{
    function makeButton(buttonHTML, type, id) {
        if (buttonHTML == '')
            return '';
        return buttonHTML.replace(/_ID_/g, id).replace(/_TYPE_/g, type);
    }

    Collections.CurrentSettlement = new Object();
    Collections.CurrentSettlement.constInfo = new Object();
    Collections.CurrentSettlement.constInfo.Title = info.Title;
    Collections.CurrentSettlement.constInfo.URL = info.URL;
    Collections.CurrentSettlement.constInfo.Lat = info.Coordinate.Lat;
    Collections.CurrentSettlement.constInfo.Long = info.Coordinate.Long;
    Collections.CurrentSettlement.constInfo.Founder = info.Founder;
    Collections.CurrentSettlement.constInfo.hasBeginning = info.hasBeginning;
    Collections.CurrentSettlement.constInfo.Legend = info.Legend;
    Collections.CurrentSettlement.constInfo.URL = info.URL;

    Collections.CurrentSettlement.editInfo = new Array();

    document.getElementById('settlement-title').innerHTML = info.Title;
    document.getElementById('settlement-url').innerHTML = info.URL;

    //jumbotron

    /// здесь сохранить в глобал
    /// потом использовать при редактировании
    /// присвоить id каждому элементу и по нему вытаскивать в форму редактирования
    /// сделать 2 класса для осн инф и для редактирования
    var text = '<div class="sidebar-left-text-element">';
    text += makeButton(editButtonText, 'constInfo', 'editConstInfoButton');
    text += '<p>' + 'Координаты: ' + info.Coordinate.Lat + ' ' + info.Coordinate.Long + '</p>';
    if (info.Founder != null)
        text += '<p>' + 'Основатель: ' + info.Founder + '</p>';

    if (info.Legend != null)
    {
        //text += '<p>' + 'Легенда:</p>';
        //  тут часть текста ("показать") выделяется другим цветом
        text += '<div class="hideLine"><label for="hideLine1">Легенда: <span style="color: #32CD32">[показать]</span></label><input type="checkbox" id="hideLine1"/>';
        text += '<p class="content">' + info.Legend + '</p></div>';
    }
    if (info.hasBeginning != null)
        text += '<p>' + 'Время основания: ' + info.hasBeginning + '</p>';
    var i = 0;
    text += '</div>'; 
    text += '<hr style="border: none; background-color: #32CD32; color: #32CD32; height: 2px;">';
    if (info.EditedSettlements != null)
        info.EditedSettlements.forEach(function (element) {
            text += '<div class="sidebar-left-text-element">';
            text += makeButton(editButtonText, 'editInfo', 'editEditInfoButton_' + i++);
            Collections.CurrentSettlement.editInfo.push(new Object(element));

            if (element.PopulationAll != null)
                text += '<p>' + 'Количество населения: ' + element.PopulationAll + '</p>';
            if (element.PopulationFemales != null)
                text += '<p>' + 'Количество мужского населения: ' + element.PopulationFemales + '</p>';
            if (element.PopulationMales != null)
                text += '<p>' + 'Количество женского населения: ' + element.PopulationMales + '</p>';
            if (element.Region != null)
                text += '<p>' + 'Регион: ' + element.Region.Title + '</p>';
            if (element.Type != null)
                text += '<p>' + 'Тип поселения: ' + element.Type.Title + '</p>';
            if (element.Title != null)
                text += '<p>' + 'Название поселения: ' + element.Title + '</p>';

            text += '<p>' + 'Год: ' + element.hasBeginning.Year + '</p>';
            if (element.Source.includes("www") || element.Source.includes("http"))
                text += '<p>Источник: <a href="' + element.Source + '">ссылка</a></p>';
            else 
                text += '<p>Источник: ' + element.Source + '</p>';

            text += '</div>';
        });    

    document.getElementById('sidebar-left-text').innerHTML = text;
}

function printExportCollection() {
    var text = '';
    //  т.к. используются формы (class="form-check...")
    //  то объекты в разметке получают стиль позиции relative
    //  данная позиция не корректно взаимодействует со скроллбаром и шапкой формы, которая имеет позицию sticky
    //  я не знаю как это лучше исправить
    //  предполагаю, что можно убрать классы и оставить только label и checkbox, тогда их позиции станут fixed и все станет норм
    Collections.Export.forEach(function (element) {
        text += '<div class="form-check">';//style="position: sticky;"
        text += '	<input class="form-check-input" type="checkbox" value="" id="' + element.url + '" checked onchange="checkBoxChange(this)">';
        text += '   <label class="form-check-label" for="' + element.url + '" data-toggle="tooltip" data-placement="top" title="' + element.url + '">' + element.name + '</label>';
        text += '</div>';
    });
    $("#sidebar-right-text-export")[0].innerHTML = text;
}

function printEditImportForm(what, id) {
    var text = '';
    if (what == 'constInfo') {
        console.log(Collections.CurrentSettlement[what]);
    }       
    else if (what == 'editInfo') {
        var i = id.split('_')[1];
        console.log(Collections.CurrentSettlement.editInfo[i]);
    }

}

//  Функция выгружает все гео-объекты из данной коллекции на карту
function PlaceFromCollection() {
    CollectionVisible.addToMap(Map);
    //Map.geoObjects.add(CollectionVisible);

    //var arr = [];
    //var i = 0;
    //var iterator = CollectionVisible.getIterator(),
    //    object;
    //while ((object = iterator.getNext()) != iterator.STOP_ITERATION) {
    //    arr[i] = object;
    //    i++;
    //}
    //clusterer.add(arr);
    //Map.geoObjects.add(clusterer);
}