﻿//Получить данные поселения по имени
function GetInfoAboutSettlement(URL, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetSettlement',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            URL: URL
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить массив всех точек поселений от сервера
function GetAllPoints(YearMin, YearMax) {
    $.ajax({
        url: '/MapAPI/GetAllPoints',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            YearMin: YearMin,
            YearMax: YearMax
        },
        success: function (data) {
            //  Заполнить массивы из полученного результата
            //  Заполнить коллекцию геообъектами
            //  
            //  Затем: 
            //  Нужно ли делать выборку
            //                     |
            //                     |
            //                     | фильтры
            //                     |     |
            //                     |     |
            FillDataArrays(data, true, false);            
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//Получить все имена поселений, подходящие по маске subName
function GetNames(subName, functionWhatNeedToDoWithInfo) {
    $.ajax({
        url: '/MapAPI/GetNames',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        //Параметр контроллеру
        data: {
            subName: subName
        },

        success: function (data) {
            functionWhatNeedToDoWithInfo(data);
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}

//  Функция запроса дат
function GetDate(load = false) {
    $.ajax({
        url: '/MapAPI/GetYears',
        type: 'GET',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        success: function (data) {
            
            MinYear = data.Item1;
            CurrentMinYear = data.Item2;
            CurrentMaxYear = MaxYear = new Date().getFullYear();

            document.getElementById('slider-label-min').innerHTML = '<b>' + MinYear + '</b>';
            document.getElementById('slider-label-max').innerHTML = '<b>' + MaxYear + '</b>';

            if (load == true) {
                SliderInit();
                GetAllPoints(CurrentMinYear, CurrentMaxYear);
            }
            //  Присвоить даты
        },

        error: function (response) {
            console.log(response.responseText);
            alert('Ошибка. Не удалось получить данные от сервера');
        }
    });
}



//function apiConnect(apiKey) {

//    function get(route) {
//        return fetch(`${route}?key=${apiKey}`);
//    }

//    function post(route, params) {
//        return
//        fetch(route,
//            {
//                method: 'POST',
//                body: JSON.stringify(params),
//                headers: {
//                    'Authorization': `Bearer ${apiKey}`
//                }
//            })
//    }

//    return { get, post }
//}
//const api = apiConnect('my-secret-key');
//// Использовать ключ доступа к API больше уже не нужно
//api.get('http://www.example.com/get-endpoint');
//api.post('http://www.example.com/post-endpoint', { name: 'Joe' });