﻿//  Функция обработчик движения слайдера
function SliderOnFinishMoving(data) {   
    CurrentMinYear = data.min;
    CurrentMaxYear = data.max;
    GetAllPoints(CurrentMinYear, CurrentMaxYear);
}

function OnFindNameUsing(name) {
    //  Добавить в коллекцию, чтобы гарантировать что данный объект появится на карте
    Collections.FindName = name;
    //  Найти метку в коллекции всех меток
    var placemark = Collections.AllGeoObjects.search('options.Name = "' + name + '"').get(0);
    //  Установить новый цвет
    placemark.options.set('preset', 'islands#greenStretchyIcon');
    //  Отцентрировать карту и приблизить
    Map.setCenter(placemark.geometry.getCoordinates(), 13);
    //  Через 5 секунд вернуть обратно прежний цвет
    setTimeout(changePlacemarkPreset, 5000, placemark, 'islands#redStretchyIcon');
}

function changePlacemarkPreset(placemark, preset) {
    placemark.options.set('preset', preset);
}

//  Заполнение массивов из исходного (response.data)
//  В соответствии с параметрами поселения
function FillDataArrays(fromData, isNeedSelect = false, isNeedFilters = false) {

    Collections.AllGeoObjects.removeFromMap(Map);

    Collections.All = new Array();
    Collections.AllGeoObjects = new ymaps.geoQuery();
    Collections.SettlementTypes = new Array();
    Collections.Regions = new Array();
    Collections.Names = new Array();
    Collections.FindName = '';

    console.log('Количество загруженных поселений ' + fromData.arraySettlements.length);

    Collections.Names = fromData.arrayNameSettlements;
    Collections.SettlementTypes = fromData.arrayNameTypes;
    Collections.Regions = fromData.arrayNameRegions;
    
    AutoCompleteInit(Collections.Names);
    filterCollectionInit(Collections.Filters.Type, Collections.SettlementTypes, 'filterGroupTypes', 'countTypes');
    filterCollectionInit(Collections.Filters.Region, Collections.Regions, 'filterGroupRegions', 'countRegions');

    Collections.All = fromData.arraySettlements;
    LoadCollection(fromData.arraySettlements, isNeedSelect, isNeedFilters);
}

//  Функция заполнения Яндекс-коллекций Яндекс-объектами из JSON массива
function LoadCollection(fromData, isNeedSelect = false, isNeedFilters = false) {
    fromData.forEach(function (element) {
        Collections.AllGeoObjects = Collections.AllGeoObjects.add(CreateYandexPlacemark(element)); //  Добавление
    });
    if (isNeedSelect)
        SelectDataFromArrays(isNeedFilters);
}

//  Согласно текущим установленным фильтрам собрать нужный массив данных
function SelectDataFromArrays(isNeedFilters = false) {
    var ResultDataArray = new Array();

    console.log("select with " + isNeedFilters);
    isNeedFilters=false;
    var insideMap = Collections.AllGeoObjects.searchInside(Map);
    var afterFilters = new ymaps.geoQuery();
    if (!isNeedFilters) 
        afterFilters = insideMap;
    else        
        {
            var typeFilters = new ymaps.geoQuery();
            var regionFilters = new ymaps.geoQuery();

            //  тут применить фильтры
            //  объединить по признаку типа 
            //  объединить по признаку региона
            //  пересечь две выборки

            for (e in Collections.Filters.Type) {
                if (Collections.Filters.Type[e]) {
                    typeFilters = insideMap.search('options.Types regexp "{|' + e + '}"').add(regionFilters);
                }
            }
            for (e in Collections.Filters.Region) {
                if (Collections.Filters.Region[e]) {
                    regionFilters = insideMap.search('options.Regions regexp "{' + e + '}"').add(regionFilters);
                }
            }

            afterFilters = typeFilters.intersect(regionFilters);
        }
    

//filterTypes = all.search('options.Regions regExp "*|gorod|*"') 
// .add(all.search('options.Regions regExp "*|selo|*"')) 
// .add(all.search('options.Regions regExp "*|poselok|*"'))

    //for (e in Collections.Filters.Type) {
    //    if (Collections.Filters.Type[e])
    //    {
    //        for 
    //    }
    //        afterFilters = afterFilters.search('options.Name = "' + name + '"');
    //}
    //for (e in Collections.Filters.Region) {
    //    Collections.Filters.Region[e] = true;
    //}

    var CollectionVisible = afterFilters.slice(0, Collections.VisibleCount).addToMap(Map);
    // Оставшиеся объекты будем удалять с карты.
    Collections.AllGeoObjects.remove(CollectionVisible).removeFromMap(Map).getLength();

    //for (var i = 0; i < Collections.All.length && i < Collections.VisibleCount; i++) {
    //    ResultDataArray.push(Collections.All[i]);
    //}

    //if (isNeedPlaceCollection)
    //    PlaceFromCollection(geo_query);
    return ResultDataArray;
}


//  Функция создания Яндекс-объекта из одного элемента JSON массива
function CreateYandexPlacemark(fromElement) {
    var coord = fromElement.Position.split(' ');
    var placemark = new ymaps.Placemark([coord[0], coord[1]],
        {
            iconContent: fromElement.Title,   //  Содержимое названия
            hintContent: fromElement.Position//  Содержимое подписи при наведении
        },
        {
            preset: 'islands#redStretchyIcon'
        }
    );

    function compose (elem) {
        var t = '';
        fromElement[elem].forEach(function (element) {
            t += ' {' + element + '}';
        });
        return t + ' ';
    }

    //Добавить свойство - Имя поселения
    placemark.options.set('Name', fromElement.Title);
    placemark.options.set('URL', fromElement.URL);
    placemark.options.set('Population', fromElement.Population);
    placemark.options.set('Types', compose('Type'));
    placemark.options.set('Regions', compose('Region'));

    //  Переопределяем стадартный обработчик нажатия
    placemark.events.add('click', function (e) {
        e.preventDefault(); //  Запрещаем стандартный обработчик

        var targetURL = e.get('target').options.get('URL');

        //  Вызов запроса на получение данных о поселении
        GetInfoAboutSettlement(targetURL, PrintInfoAboutSettlement);
        //  Показать боковую панель
        if ($('#sidebar-left, #content').hasClass('active')) {
            //  Панель скрыта. Должна выехать
            $('#sidebar-left, #content').removeClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
        }
        else
            //  Панель есть. Выбор, нужно ли её скрывать
            if (targetURL == document.getElementById('settlement-url').innerHTML) {
                $('#sidebar-left, #content').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            }


    });
    return placemark;
}


// функция динамической сортировки
function compareValues(key, order = 'asc') {
    return function (a, b) {
        if (!a.hasOwnProperty(key) || !b.hasOwnProperty(key)) {
            // свойства нет ни в одном из объектов
            return 0;
        }

        const varA = (typeof a[key] === 'string') ?
            a[key].toUpperCase() : a[key];
        const varB = (typeof b[key] === 'string') ?
            b[key].toUpperCase() : b[key];

        let comparison = 0;
        if (varA > varB) {
            comparison = 1;
        } else if (varA < varB) {
            comparison = -1;
        }
        return (
            (order == 'desc') ? (comparison * -1) : comparison
        );
    };
}

function OpenRightPanel(addclass) {
    $('#sidebar-right, #content').removeClass('active');
    $('#sidebar-right, #content').addClass(addclass);
    $('.collapse.in').toggleClass('in');
    $('a[aria-expanded=true]').attr('aria-expanded', 'false');  
}

function CloseRightPanel() {
    $('#sidebar-right, #content').addClass('active');
    $('#sidebar-right, #content').removeClass('export');
    $('#sidebar-right, #content').removeClass('import');
    $('.collapse.in').toggleClass('in');
    $('a[aria-expanded=true]').attr('aria-expanded', 'false');
}

function exportSidebarButton() { 
    //  панель закрыта
    if ($('#sidebar-right, #content').hasClass('active')) {
        switchRightSidebar('export');
        OpenRightPanel('export');
    }//  панель открыта
    else {
        //  был открыт импорт, нужно обновить содержимое
        if ($('#sidebar-right, #content').hasClass('import')) {
            switchRightSidebar('export');
            $('#sidebar-right, #content').removeClass('import');
            $('#sidebar-right, #content').addClass('export');
        }
        //  был открыт экспорт, при повторном нажатии нужно скрыть панель
        else
            CloseRightPanel();
    }
}

function importSidebarButton() {
    //  панель закрыта
    if ($('#sidebar-right, #content').hasClass('active')) {
        switchRightSidebar('import');
        OpenRightPanel('import');
    }//  панель открыта
    else {
        //  был открыт экспорт, нужно обновить содержимое
        if ($('#sidebar-right, #content').hasClass('export')) {
            switchRightSidebar('import');
            $('#sidebar-right, #content').removeClass('export');
            $('#sidebar-right, #content').addClass('import');
        }
        //  был открыт импорт, при повторном нажатии нужно скрыть панель
        else
            CloseRightPanel();
    }    
}

function switchRightSidebar(flag) {
    if (flag === 'export')
    {
        printExportCollection();
        document.getElementById('sidebar-right-header-title').innerHTML = 'Экспорт';
        document.getElementById('export-to-word').hidden = false;
        document.getElementById('export-to-excel').hidden = false;
        document.getElementById('sidebar-right-text-export').hidden = false;

        document.getElementById('import-button').hidden = true;
        document.getElementById('sidebar-right-text-import').hidden = true;
    } else if (flag === 'import')
    {
        document.getElementById('sidebar-right-header-title').innerHTML = 'Импорт';
        document.getElementById('export-to-word').hidden = true;
        document.getElementById('export-to-excel').hidden = true;
        document.getElementById('sidebar-right-text-export').hidden = true;

        document.getElementById('import-button').hidden = false;
        document.getElementById('sidebar-right-text-import').hidden = false;
    }
    
}

function checkBoxChange(e) {
    if (e.checked) {
        // пользователь передумал и решил вернуть поселение в экспорт   
        var element = new Object();
        element.name = e.parentElement.innerText;
        element.url = e.id;
        Collections.Export.push(element);
    }
    else
    {
        //  пользователь убрал отметку экспорта. удаляем поселение из коллекции
        //  но отрисовку пока не делаем, вдруг он захочет вернуть отметку (т.е. добавить в экспорт)
        Collections.Export = jQuery.grep(Collections.Export, function (element) {
            return element.url != e.id;
        });
    }
}

function addToExport() {
    var element = new Object();
    element.name = $("#settlement-title")[0].innerHTML;
    element.url = $("#settlement-url")[0].innerHTML;

    //  нельзя добавить уже добавленное поселение
    if (!Collections.Export.some(currentValue => currentValue.url == element.url)){
        Collections.Export.push(element);
        printExportCollection();
    }
    
}

function filterRegionChange(e) {
    //console.log($("#"+e.id));
    var name = e.parentElement.parentElement.parentElement.children[1].innerText;
    Collections.Filters.Region[name] = e.checked;
}

function filterTypeChange(e) {
    //console.log($("#" + e.id));
    var name = e.parentElement.parentElement.parentElement.children[1].innerText;
    Collections.Filters.Type[name] = e.checked;
}

function defaultFilters() {

    for (e in Collections.Filters.Type) {
        Collections.Filters.Type[e] = true;
    } 
    for (e in Collections.Filters.Region) {
        Collections.Filters.Region[e] = true;
    }

    $("#filterGroups input").each(function (index, element) {
        element.checked = true;
    });
    SelectDataFromArrays(false);

    //console.log($("#filterGroupRegions")[0].children);
}

function activeFilters() {
    SelectDataFromArrays(true);
}
