﻿ymaps.ready(init);

function init() {
    var map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 7,
            type: 'yandex#hybrid',
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
        );
    map.controls.get('zoomControl').options.set({ size: 'auto' });
    map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite', 'yandex#hybrid']));


    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#ffffff',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            map.geoObjects.add(background);
        });

    var allMarks = new ymaps.GeoObjectCollection({},
        {
            preset: 'islands#redStretchyIcon'
        });

    // Имя, тип_поселения, координаты, дата_основания
    var response =
        [
            ["Саратов", "Город", [51.533103, 46.034158], 1590],
            ["Балаково", "Город", [52.02782, 47.8007], 1911],
            ["Балашов", "Город", [51.5502, 43.1667], 1780],
            ["Маркс", "Город", [51.71111, 46.74861], 1942]
        ]

    function loadMarks() {
        allMarks.removeAll();
        //sendRequest
        //var response = getRequest().then(function)
        {
            response.forEach(function (el, i, response) {
                var tmp = new ymaps.Placemark(el[2],
                    {
                        iconContent: el[0],
                        //balloonContent: String(el[1]) + " " + String(el[0]) + ". Год основания " + String(el[3]),
                        hintContent: el[2]
                    }
                );
                tmp.events.add('click', function (e) {
                    e.preventDefault();
                    alert(String(el[1]) + " " + String(el[0]) + ". Год основания " + String(el[3]));
                });
                allMarks.add(tmp);
            });
            map.geoObjects.add(allMarks);
        }
    }
    loadMarks();
}
