﻿ymaps.ready(init);





function init() {
    var map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 7,
            type: 'yandex#hybrid',
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
        );
    map.controls.get('zoomControl').options.set({ size: 'auto' });
    map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite', 'yandex#hybrid']));


    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#ffffff',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            map.geoObjects.add(background);
        });

    var startData;
    function onLoad()
    {
        Data = new Date();
        console.log("onLoad: " + Data.getHours() + "." + Data.getMinutes() + "." + Data.getSeconds());
        startData = getData(0);
    }
    onLoad();
    //console.log(startData);

    var allMarks = new ymaps.GeoObjectCollection({},
        {
            preset: 'islands#redStretchyIcon'
        });
    loadMarks(allMarks, startData);
    map.geoObjects.add(allMarks);
}

function loadMarks(collection, fromData)
{
    collection.removeAll();
    //sendRequest
    //var response = getRequest().then(function)
    {
        Data = new Date();     
        console.log("loadMarks: " + Data.getHours() + "." + Data.getMinutes() + "." + Data.getSeconds());
        
        fromData.forEach(function (el)
        {
            console.log("2");
            var tmp = new ymaps.Placemark(el.Position,
                {
                    iconContent: el.Name,
                    //balloonContent: String(el[1]) + " " + String(el[0]) + ". Год основания " + String(el[3]),
                    hintContent: el.Position
                }
            );
            tmp.events.add('click', function (e) {
                e.preventDefault();
                alert(String(el.Type) + " " + String(el.Name) + ". Год основания " + String(el.Year));
            });
            collection.add(tmp);
        });   
        console.log("3");
    }
}


function getData(id)
{
    Data = new Date();
    console.log("getData: " + Data.getHours() + "." + Data.getMinutes() + "." + Data.getSeconds());
    var result = new Array();
    console.log(result);
    $.ajax({
        url: '/Map/MapData',
        type: 'PUT',
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,

        success: function (data) {
            for (var i = 0; i < data.length; i++) {
                var temp = Parse(data[i]);
                console.log(temp);
                result.push(temp);
                console.log(result.length);
                console.log(result.i);
            }
            console.log("result length " + result.length);
            //  !!!!!!!!!!!!!!! Здесь нужно не самописный метод, а JSON.parse
        },

        error: function (response) {
            console.log(response.responseText);
        }
    });
    console.log("result");
    console.log(result);
    console.log("result length " + result.length);
    return result;
}

function Parse(obJSON) {
    Data = new Date();
    console.log("Parse: " + Data.getHours() + "." + Data.getMinutes() + "." + Data.getSeconds());
    var res = new Object();

    res.Name = obJSON["Name"];
    res.Position = [obJSON["position"].X, obJSON["position"].Y];

    res.Year = obJSON["Year"];
    res.Type = obJSON["Type"];

    return res;
}



