﻿ymaps.ready(init);

var collectionAll;
var collectionReligion_1;
var collectionReligion_2;
var collectionReligion_3;
var collectionReligion_4;
var collectionName;
var collectionExport;

var map;

function init() {
    map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 7,
            type: 'yandex#hybrid',
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
        );
    map.controls.get('zoomControl').options.set({ size: 'auto' });
    map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite', 'yandex#hybrid']));


    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#ffffff',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            map.geoObjects.add(background);
        });

    //  Набор коллекций, которые формируются для более гибкого отображения данных на странице.
    //  Объявлены, как глобальные переменные, однако инициализируются лишь один раз.
    collectionAll = new ymaps.GeoObjectCollection({},
        {
            //  Параметр коллекции всех элементов, отображающий название в красной рамке
            preset: 'islands#redStretchyIcon'
        });
    collectionReligion_1 = new ymaps.GeoObjectCollection();
    collectionReligion_2 = new ymaps.GeoObjectCollection();
    collectionReligion_3 = new ymaps.GeoObjectCollection();
    collectionReligion_4 = new ymaps.GeoObjectCollection();
    collectionName = new ymaps.GeoObjectCollection();
    collectionExport = new ymaps.GeoObjectCollection();

    //  Функция, осуществляющая первую загрузку данных с параметром 0 (см. запрос в модели данных сервера)
    function onLoad() {getData(0);}
    onLoad(); 
}

//  Функция, помещающая новые геобъекты на основе переданного массива fromData в переданную коллекцию collection
function loadMarks(collection, fromData)
{
    //  Очистка коллекции от старых элементов. Параметры остаются прежними
    collection.removeAll(); 
    fromData.forEach(function (el)
    {
        var tmp = new ymaps.Placemark(el.position,
            {
                iconContent: el.Name,   //  Содержимое названия
                hintContent: el.position//  Содержитмое подписи при наведении
            }
        );      
        //  Переопределяем стадартный обработчик нажатия
        tmp.events.add('click', function (e) {
            e.preventDefault(); //  Запрещаем стандартный обработчик
            alert(String(el.Type) + " " + String(el.Name) + ". Год основания " + String(el.Year));
        });
        //  Добавление нового геообъекта в коллекцию
        collection.add(tmp);
    });   
}

//  Функция отправки запроса с переданным id, который позволит выбрать тип запроса на контроллере
function getData(id)
{
    //  Асинхронный запрос к контроллеру Map методу MapData(string id)
    $.ajax({
        url: '/Map/MapData',
        type: 'POST',
        //data : "", // Параметры запроса
        contentType: "application/json; charset=utf-8",
        dataType: 'json',
        cache: false,
        success: function (data)
        {
            //  В случае успеха, загрузи данные в коллекции.
            loadCollections(data);   
            //  Асинхронность подразумевает, что создается отдельный поток обработки, поэтому необходим последовательный вызов всех зависимых компонентов
        },

        error: function (response) {
            //  Ошибка
            console.log(response.responseText);
        }
        });
}

function loadCollections(fromData)
{
    //  json данные необходимо конвертировать в новый массив, чтобы упростить заполнение коллекций с помощью встроенных фильтров
    var data = [];
    fromData.forEach(function (el) {
        data.push(Parse(el));
        //  !!!!!!!!!!!!!!! Здесь нужно не самописный метод, а JSON.parse
    });

    //  Вызов внесения переданных данных (из нужного массива) в коллекцию
    loadMarks(collectionAll, data);
    // loadMarks(collectionReligion_1, "массив с выборкой по религии_1");


    //  для начала, отобразим полную коллекцию
    map.geoObjects.add(collectionAll);

    //  Применить фильтры, если таковые установлены
}


//  Самописный парсер json объекта (не массива), жестко связанный с моделью
function Parse(obJSON) {
    var res = new Object();

    res.Name = obJSON["Name"];
    res.position = [obJSON["position"].X, obJSON["position"].Y];

    res.Year = obJSON["Year"];
    res.Type = obJSON["Type"];

    return res;
}



