﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace web_map.Controllers
{
    public class MapController : Controller
    {
        // GET: Map
        public ActionResult Map()
        {
            return View();
        }

        [HttpPost]
        public JsonResult MapData(string id)
        {
            if (Convert.ToInt32(id) == 0)
            {
                List<Settlement> data = Settlement.GetData();
                //var smth = Json(data, JsonRequestBehavior.AllowGet);


                return Json(data, JsonRequestBehavior.AllowGet);
                //return Json("abc", JsonRequestBehavior.AllowGet);
            }
            return Json(null, JsonRequestBehavior.AllowGet);
        }


        //  Костыль, который надо перенести в модель данных
        public class Settlement
        {
            public class Position
            {

                public double X { set; get; }
                public double Y { set; get; }

            }
            public string Name { set; get; }
            public Position position { set; get; }

            public int Year { set; get; }
            public string Type { set; get; }

            public static List<Settlement> GetData(int Count = 5)
            {
                List<Settlement> settlements = new List<Settlement>()
                {
                    new Settlement() { Name = "Саратов", Type = "Город", position = new Position() {X = 51.533103, Y = 46.034158 }, Year = 1590 },
                    new Settlement() { Name = "Балаково", Type = "Город", position = new Position() { X = 52.02782, Y = 47.8007 }, Year = 1911 },
                    new Settlement() { Name = "Балашов", Type = "Город", position = new Position() { X = 51.5502, Y = 43.1667 }, Year = 1780 },
                    new Settlement() { Name = "Маркс", Type = "Город", position = new Position() { X = 51.71111, Y = 46.74861 }, Year = 1942 }
                };
                return settlements;
            }
        }
    }
}