﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel;

namespace ModelData.WebModel
{
    public class WebDataManager
    {
        #region singl

        private static WebDataManager dataManager;
        public static WebDataManager Get()
        {
            if (dataManager == null)
                dataManager = new WebDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private WebDataManager()
        {
            Init();
        }

        #endregion

        #region Data
        #endregion

        #region Methods

        public MapPoint[] GetMapPoints()
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            Settlement[] settlements = businessData.GetSettlements();
            List<MapPoint> mapPoints = new List<MapPoint>(settlements.Length);

            foreach (var elem in settlements)
                mapPoints.Add(new MapPoint()
                {
                    Name = elem.Name,
                    Position = elem.position
                });

            return mapPoints.ToArray();
        }

        public Settlement GetSettlement(string name)
        {
            BusinessDataManager businessData = BusinessDataManager.Get();

            return businessData.GetSettlement(name);
        }

        #region Tools

        private void Init(int Count = 5)
        {            
        }
        #endregion

        #endregion

    }
}
