﻿ymaps.ready(MapInit);

function MapInit()
{
    YandexMapInit();
    GetDate();
    SliderInit();
    CollectionsInit();
    GetAllPoints(CurrentMinYear, CurrentMaxYear);
}

var collectionAll;
var collectionReligion_1;
var collectionReligion_2;
var collectionReligion_3;
var collectionReligion_4;
var collectionName;
var collectionExport;

var Map;
var MinYear;
var MaxYear;
var CurrentMinYear;
var CurrentMaxYear;

//  Функция загрузки Яндекс карты
function YandexMapInit()
{
    Map = new ymaps.Map
        ('map', {
            center: [51.533103, 46.034158],
            zoom: 7,
            type: 'yandex#hybrid',
            controls: ['zoomControl', 'rulerControl']
        },
        {
            // Ограничим область карты.
            restrictMapArea: [[48.795, 41.484], [53.823, 51.856]]
            //restrictMapArea: [[49.795, 42.484], [52.823, 50.856]]
        }
        );
    Map.controls.get('zoomControl').options.set({ size: 'auto' });
    Map.controls.add(new ymaps.control.TypeSelector(['yandex#map', 'yandex#satellite', 'yandex#hybrid']));


    // Загрузим регионы.
    ymaps.borders.load
        ('RU', { lang: 'ru', quality: 3 }).then
        (function (result) {
            // Создадим многоугольник, который будет скрывать весь мир, кроме заданной области.
            var background = new ymaps.Polygon
                (
                [[
                    [85, -179.99],
                    [85, 179.99],
                    [-85, 179.99],
                    [-85, -179.99],
                    [85, -179.99]
                ]],
                {},
                {
                    fillColor: '#ffffff',
                    strokeWidth: 0,
                    // Для того чтобы полигон отобразился на весь мир, нам нужно поменять
                    // алгоритм пересчета координат геометрии в пиксельные координаты.
                    coordRendering: 'straightPath'
                }
                );

            // Найдём область по её iso коду.
            var region = result.features.filter(function (feature) { return feature.properties.iso3166 == 'RU-SAR'; })[0];
            // Добавим координаты этой области в полигон, который накрывает весь мир.
            // В полигоне образуется полость, через которую будет видно заданную область.
            var masks = region.geometry.coordinates;

            masks.forEach(function (mask) { background.geometry.insert(1, mask); });
            // Добавим многоугольник на карту.
            Map.geoObjects.add(background);
        });    
}

//  Функция создания слайдера дат и обработчик поля ввода дат
function SliderInit() {
    // $j optional alias to jQuery noConflict()
    var $j = jQuery.noConflict();
    var $slider;

    $j(document).ready(function () {
        $slider = $("#slider").ionRangeSlider({
            skin: "modern",
            hide_min_max: true,
            type: "double",
            grid: true,
            drag_interval: true,
            min: MinYear,
            max: MaxYear,
            from: CurrentMinYear,
            to: new Date().getFullYear(),
            onFinish: function (data) {
                console.log("finish");
                // Called then action is done and mouse is released
                SliderOnFinishMoving(data);
            },
            onUpdate: function (data) {
                console.log("update");
                // Called then action is done and mouse is released
                SliderOnFinishMoving(data);
            }
        });
    });
    //  Поле ввода даты. Обработчик изменения дат слайдера
    var inputField = document.getElementById('inputYear');
    inputField.oninput = function () {
        if (inputField.value <= MaxYear && inputField.value >= MinYear) {
            var slider_instance = $slider.data("ionRangeSlider");
            slider_instance.update({
                from: inputField.value,
                to: inputField.value
            });
        }

    };
}

//  Функция создания коллекций Яндекс-объектов
function CollectionsInit() {
    //  Набор коллекций, которые формируются для более гибкого отображения данных на странице.
    //  Объявлены, как глобальные переменные, однако инициализируются лишь один раз.
    collectionAll = new ymaps.GeoObjectCollection({},
        {
            //  Параметр коллекции всех элементов, отображающий название в красной рамке
            preset: 'islands#redStretchyIcon'
        });
    collectionReligion_1 = new ymaps.GeoObjectCollection();
    collectionReligion_2 = new ymaps.GeoObjectCollection();
    collectionReligion_3 = new ymaps.GeoObjectCollection();
    collectionReligion_4 = new ymaps.GeoObjectCollection();
    collectionName = new ymaps.GeoObjectCollection();
    collectionExport = new ymaps.GeoObjectCollection();
}