﻿//  Функция обработчик движения слайдера
function SliderOnFinishMoving(data) {
    console.log(data.from + " " + data.to);
}

//  Функция заполнения Яндекс-коллекций Яндекс-объектами из JSON массива
function LoadCollection(collection, fromData, bool = false) {
    if (bool == true)
        collection.removeAll(); //  Очистка коллекции от старых элементов. Параметры остаются прежними

    fromData.forEach(function (element) {
        collection.add(CreateYandexPlacemark(element)); //  Добавление
    });
}

//  Функция создания Яндекс-объекта из одного элемента JSON массива
function CreateYandexPlacemark(fromElement) {
    var placemark = new ymaps.Placemark([fromElement.Position.X, fromElement.Position.Y],
        {
            iconContent: fromElement.Name,   //  Содержимое названия
            hintContent: [fromElement.Position.X, fromElement.Position.Y]//  Содержимое подписи при наведении
        }
    );

    //Добавить свойство - Имя поселения
    placemark.options.set('Name', fromElement.Name);

    //  Переопределяем стадартный обработчик нажатия
    placemark.events.add('click', function (e) {
        e.preventDefault(); //  Запрещаем стандартный обработчик

        var targetName = e.get('target').options.get('Name');

        //  Вызов запроса на получение данных о поселении
        GetInfoAboutSettlement(targetName, PrintInfoAboutSettlement);

        //  Показать боковую панель
        if ($('#sidebar, #content').hasClass('active')) {
            //  Панель скрыта. Должна выехать
            $('#sidebar, #content').removeClass('active');
            $('.collapse.in').toggleClass('in');
            $('a[aria-expanded=true]').attr('aria-expanded', 'false');
        }
        else
            //  Панель есть. Выбор, нужно ли её скрывать
            if (targetName == document.getElementById('sidebar-header').getElementsByTagName('*')[0].innerHTML) {
                $('#sidebar, #content').addClass('active');
                $('.collapse.in').toggleClass('in');
                $('a[aria-expanded=true]').attr('aria-expanded', 'false');
            }


    });
    return placemark;
}