﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VDS.RDF;
using VDS.RDF.Query;
using VDS.RDF.Parsing;
using VDS.RDF.Writing;

namespace ModelData.BusinessModel
{
    public class RDFQuery
    {

        static void example(string[] args)
        {
            SparqlQueryParser parser = new SparqlQueryParser(); // просто парсер

            SparqlQuery q = parser.ParseFromString("SELECT * WHERE { ?s a ?type }"); // а это экземпляр запроса, спарсенный из строки

            //  Пример параметризованного запроса, который затем парсится в SparqlQuery
            /*

            //Create a Parameterized String
            SparqlParameterizedString queryString = new SparqlParameterizedString();

            //Add a namespace declaration
            queryString.Namespaces.AddNamespace("ex", new Uri("http://example.org/ns#"));

            //Set the SPARQL command
            //For more complex queries we can do this in multiple lines by using += on the
            //CommandText property
            //Note we can use @name style parameters here
            queryString.CommandText = "SELECT * WHERE { ?s ex:property @value }";

            //Inject a Value for the parameter
            queryString.SetUri("value", new Uri("http://example.org/value"));

            //When we call ToString() we get the full command text with namespaces appended as PREFIX
            //declarations and any parameters replaced with their declared values
            Console.WriteLine(queryString.ToString());

            //We can turn this into a query by parsing it as in our previous example
            SparqlQuery query = parser.ParseFromString(queryString);

            */

            string exQuery = "SELECT * WHERE { ?obj a ?subj }";

            //Create endpoint and make our query
            SparqlRemoteEndpoint endpoint = new SparqlRemoteEndpoint(new Uri("http://jena.denhome.keenetic.link/map/query"));
            SparqlResultSet results = endpoint.QueryWithResultSet(exQuery);


            System.IO.StreamWriter outStream = new System.IO.StreamWriter("D:\\gggg.txt");
            outStream.Write(new System.IO.StreamReader(endpoint.QueryRaw(exQuery).GetResponseStream()).ReadToEnd()); outStream.Close();

            //Now save this to disk as SPARQL JSON
            SparqlJsonWriter writer = new SparqlJsonWriter();
            writer.Save(results, "D:\\example.srj");

            //We can then read this pack in again
            SparqlJsonParser reader = new SparqlJsonParser();
            SparqlResultSet results2 = new SparqlResultSet();
            reader.Load(results2, "D:\\example.srj");

        }
    }
}
