﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;


using ModelData.WebModel;

namespace web_map.Controllers
{
    public class MapAPIController : Controller
    {
        /// <summary>
        /// WebModel MapPoint
        /// Данные всех объектов базы
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetAllPoints(int YearMin, int YearMax)
        {
            WebDataManager webData = WebDataManager.Get();

            return Json(webData.GetMapPoints(), JsonRequestBehavior.AllowGet);
        }

        /// <summary>
        /// Buisness Settlement 
        /// Данные конкретного поселения
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetSettlement(string Name)
        {
            WebDataManager webData = WebDataManager.Get();

            return Json(webData.GetSettlement(Name), JsonRequestBehavior.AllowGet);
        }

    }
}