﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel
{
    public class BusinessDataManager
    {
        #region singl

        private static BusinessDataManager dataManager;
        public static BusinessDataManager Get()
        {
            if (dataManager == null)
                dataManager = new BusinessDataManager();

            return dataManager;
        }
        public static void Destroy()
        {
            dataManager = null;
        }

        private BusinessDataManager()
        {
            Init();
        }

        #endregion

        #region Data

        private List<Settlement> lst_settlements;

        #endregion

        #region Methods

        public Settlement[] GetSettlements()
        {
            return lst_settlements.ToArray();
        }

        public Settlement GetSettlement(string name)
        {
            return lst_settlements[FindByName(name)];
        }

        #region Tools

        private void Init()
        {
            lst_settlements = new List<Settlement>();

            lst_settlements.Add(new Settlement
                (
                    name_: "Саратов", 
                    position_: new Position(51.533103, 46.034158), 
                    year_: "1590", 
                    type_: "Город",
                    description_: "Город на юго-востоке европейской части России, административный центр Саратовской области и Саратовского района," +
                    "в который не входит, являясь городом областного значения, образует муниципальное образование город Саратов со статусом " +
                    "городского округа. Крупный культурный, экономический и образовательный центр Поволжья. Входит в двадцатку крупнейших" +
                    "городов России, не будучи городом-миллионером, одновременно является центром Саратовской агломерации, население которой " +
                    "превышает 1,2 млн человек. Находится на правом берегу Волгоградского водохранилища реки Волги, в 389 км от Волгограда и" +
                    "442 км от Самары, в 858 км к юго-востоку от Москвы."
                ));

            lst_settlements.Add(new Settlement
                (
                    name_: "Балаково",
                    position_: new Position(52.02782, 47.8007),
                    year_: "1762",
                    type_: "Город",
                    description_: "Город, находящийся в юго-восточной европейской части России, административный центр Балаковского муниципального района " +
                    "Саратовской области. Образует одноимённое муниципальное образование город Балаково со статусом городского поселения как " +
                    "единственный населённый пункт в его составе. Располагается на левом берегу реки Волга и острове (Жилгородок)."
                ));

            lst_settlements.Add(new Settlement
                (
                    name_: "Балашов",
                    position_: new Position(51.5502, 43.1667),
                    year_: "XVIII век",
                    type_: "Город",
                    description_: "Город расположен на восточной окраине Окско-Донской равнины, на реке Хопёр (приток Дона), на пересечении железнодорожных " +
                    "линий Тамбов — Камышин и Поворино — Пенза, в 210 км к западу от Саратова. Через город протекает одна из красивейших рек " +
                    "средней полосы России — Хопёр, которая делит Балашов на две неравные части — частный сектор и центральный, с постройками " +
                    "городского типа. Вблизи города находится военный аэродром Балашов и военный городок Восход (Балашов-13)."
                ));

            lst_settlements.Add(new Settlement
                (
                    name_: "Маркс",                    
                    position_: new Position(51.71111, 46.74861),
                    year_: "1765",
                    type_: "Город",
                    description_: "Город, расположенный на левом берегу Волги, в 60 км к северо-востоку от Саратова, административный центр Марксовского" +
                    "муниципального района Саратовской области. Образует одноимённое муниципальное образование город Маркс со статусом городского поселения " +
                    "как единственный населённый пункт в его составе.",
                    names_: new List<SettlementName> {
                        new SettlementName("Екатериненштадт (Баронск)", "1765", "1915"),
                        new SettlementName("Екатериноград", "1915", "1920"),
                        new SettlementName("Марксшта́дт", "1920", "1942"),
                        new SettlementName("Маркс", "1942")}
                ));

        }
        private int FindByName(string name)
        {
            for (int i = 0; i < lst_settlements.Count; i++)
            {
                if (lst_settlements[i].Name == name)
                    return i;
            }
            return -1;
        }

        #endregion

        #endregion

    }
}
