﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModelData.BusinessModel
{
    public class Settlement
    {
        public string Name { set; get; }
        public List<SettlementName> Names { set; get; }
        public Position position { set; get; }

        public string Year { set; get; }
        public string Type { set; get; }

        public string Description { set; get; }

        public Settlement(string name_, Position position_, string year_, string type_ = null, string description_ = null, List<SettlementName> names_ = null) 
        {
            this.Name = name_;
            this.position = position_;
            this.Year = year_;
            this.Type = type_ ?? "";
            this.Description = description_ ?? "";
            this.Names = (names_ != null && names_.Count > 0) ? new List<SettlementName>(names_) : null;
        }

    }

    public class SettlementName
    {
        public string Name { set; get; }
        public TimeInterval Interval { set; get; }

        public SettlementName(){ }
        public SettlementName(string name_, string start_)
        {
            this.Name = name_;
            this.Interval = new TimeInterval(start_);
        }
        public SettlementName(string name_, string start_, string end_)
        {
            this.Name = name_;
            this.Interval = new TimeInterval(start_, end_);
        }
    }

    public class TimeInterval
    {
        public string Start { set; get; }
        public string End { set; get; }

        public TimeInterval(){ }
        public TimeInterval(string start_)
        {
            this.Start = start_;
        }
        public TimeInterval(string start_, string end_)
        {
            this.Start = start_;
            this.End = end_;
        }
    }
}
