﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ModelData.BusinessModel.MainEntities;

namespace ModelData.WebModel
{
    public class Model
    {
        public MapPoint[] arraySettlements { set; get; }
        public SettlementName[] arrayNameSettlements { set; get; }
        public string[] arrayNameTypes { set; get; }
		public string[] arrayNameRegions { set; get; }
		public Dictionary<string, int> ZoomLevel { private set; get; }

		public Model()
		{
			ZoomLevel = new Dictionary<string, int>();
		}

		public void InitZoom(int population)
		{
			ZoomLevel = new Dictionary<string, int>
			{
				{"Zoom_8", (int) (population * 0.2f) },
				{"Zoom_9", (int) (population * 0.1f) },
				{"Zoom_10", (int) (population * 0.05f) },
				{"Zoom_11", (int) (population * 0.01f) },
				{"Zoom_12", (int) (population * 0.006f) },
				{"Zoom_13", (int) (population * 0.003f) },
				{"Zoom_14", (int) (population * 0.001f) },
				{"Zoom_15", (int) (population * 0.0008f) },
				{"Zoom_16", (int) (population * 0.0006f) },
				{"Zoom_17", (int) (population * 0.0004f) },
				{"Zoom_18", (int) (population * 0.0002f) },
				{"Zoom_19", 0 }
			};
		}
	}
}
