﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.IO;

using ModelData.WebModel;
using Tools.Word;

namespace web_map.Controllers
{
    public class MapController : BaseController
    {
        // GET: Map
        public ActionResult Map()
        {
            return View();
        }

        public FileResult ExportInfo(string data, string type)
        {
            //WebDataManager webData = WebDataManager.Get();

            //  Я так и не успел реализовать возможность экспорта в формат эксель поэтому тут просто создается ворд файл
            //  параметр type принимает два занчения: "word" или "excel"
            //  для создания ворд файла используется бибилотека DocX
            //  для создания эксель файла подключена библиотека EPPlus, которая не используется
            //  созданием документа занимается DocXWrite из пространства имен Tools.Word проекта Tools
            //  рекомендую создать там пространство имен Tools.Excel , какой-либо соотвествующий класс
            //  и реализовать вывод данных в эксель формат
            //
            //  переменная inputList содержит список всех переданных url основных поселений которые нужно экспортировать
            //  для большей ионфорации рекомендую просмотреть класс DocXWrite

            var inputList = data.Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries).ToList<string>();
            var infoList = new List<ModelData.BusinessModel.MainEntities.Settlement>(inputList.Count);

            WebDataManager webData = WebDataManager.Get();
            foreach (var item in inputList)
                infoList.Add(webData.GetSettlement(item));

            DocXWrite.PrintDocX(infoList, out MemoryStream mr);

            string file_name = "info.docx";

            return File(mr, System.Net.Mime.MediaTypeNames.Application.Octet, file_name);
        }

        [HttpPost]
        public JsonResult ImportForm(string formData, string type)
        {
            string result = "";
            if (User.Identity.IsAuthenticated)
            {
                WebDataManager webData = WebDataManager.Get();

                var inputArray = formData.Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries);
                Dictionary<string, string> form = new Dictionary<string, string>();
                string key, value;
                foreach (var elem in inputArray)
                {
                    key = elem.Split('~')[0];
                    value = elem.Split('~')[1];
                    if (value == "null" || value == null)
                        value = "";
                    form.Add(key, value);
                }

                //  Здесь параметр type указывает, нужно создать/изменить информацию об измененном или основном поселении
                //  параметр принимает два значения: "origin-import" - основное поселение ИЛИ "edited-import" - измененное поселение
                //  параметр formData содержит переданные из формы значения, которые уникальны для каждого из двух типов
                //  
                //  в результате в переменную form запишутся все распарсенные значения, полученные с формы
                //  
                //  дальше, в зависимости от типа, нужно произвести проверку на наличие сущностей в онтологии (sparql запрос ask), добавить или удалить+добавить сведения в онтологию
                //  придется воспользоваться запросом на получения крайнего числа в url записи изменных поселений этот запрос выглядит вот так:
                //SELECT (MAX(?value) AS ?maxValue)
                //WHERE
                //{
                //  ?editedSettlement a map: EditedSettlement.
                //   BIND(str(?editedSettlement) as ? str)
                //  BIND(xsd: int(SUBSTR(?str, strlen(?str) - 3, 4)) as ? value)
                //}
                //  полученное число - крайнее для всех изменных поселений поэтому для нового изменного поселения нужно сделать +1
                //  вид url для изменных поселений такой: ИмяОсновногоПоселенияXXXX, где XXXX - число от 0000 до 9999 которое значит сквозную нумерацию всех изменных поселений (вопросы к разработчику онтологии)
                //  например: Saratov0023 Saratov0178 Sergeevka1234
                //
                //  если нужно добавить новое основное поселение придется прибегнуть к генерации URL.
                //  в переданной форме будет название поселения, которое преобразуем транслитерацией в url.
                //  модуль транслитерации находится в проекте Tools в пространстве имен Tools. обращение такое: Tools.Translit.TranslitFromRussian(строка)
                //  создаем url такого вида: Название_Название+координаты без точек_origin
                //  название берем из транслитерации, координаты записываем без точек просто подряд цифры в последовательность long,lat (долгота, широта)
                //  потом нижнее подчеркивание _ и приписка origin
                //  например: Kaluga_Kaluga4716670951371835_origin где lat = 51.371835 long = 47.166709

                //  все преобразования url, проверки ask и тд. лучше делать в BusinessDataManager, т.е. перекинуть полученные данные в WebDataManager, оттуда в Business, там сформировать полный набор параметров
                //  параметры передать в RDFQuery, составить запрос в Queries, получить ответ от точки доступа и передать ответ сюда
                //  ответ распарсить и отправить клиенту в переменной result

                //  Я ВСЕ ЭТО СПРОЕКТИРОВАЛ, НО СЛЕГКА НЕ ХВАТИЛО ВРЕМЕНИ ДЛЯ РЕАЛИЗАЦИИ (12.06.2019), желаю удачи если кто-то это будет доделывать

                result = "Success";
                //result = "Failure|ErrorMessage";
            }
            else
                result = "Failure|Пользователь не авторизован.";

            return Json(result, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult DeleteSettlement(string type, string url)
        {
            string result = "";
            if (User.Identity.IsAuthenticated)
            {
                //  Здесь примерно такие же проблемы, как описанные выше, поэтому можно читать там
                //  Удаление не реализовано, но вся его суть - сформировать sparql запрос, получить ответ и отправить ответ на клиентскую часть
                WebDataManager webData = WebDataManager.Get();
                if (new Random().Next(2) == 0)
                {
                    result = "Success";
                }
                else
                {
                    result = "Failure|ErrorMessage";
                }
            }
            else
                result = "Failure|Пользователь не авторизован.";
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        [HttpGet]
        public JsonResult GetAllOfType(string type)
        {
            WebDataManager webData = WebDataManager.Get();
            if (type == "type")
            {
                return Json(webData.GetAllSettlementTypes(), JsonRequestBehavior.AllowGet);
            }
            else if (type == "region")
            {
                return Json(webData.GetAllRegions(), JsonRequestBehavior.AllowGet);
            }
            else
                return Json(""/*webData.GetSettlementsNames(type)*/, JsonRequestBehavior.AllowGet);
        }
    }
}