﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Web.Security;
using System.Web.Routing;

namespace web_map.Controllers
{
    public abstract class BaseController : Controller
    {

        protected override void Initialize(RequestContext requestContext)
        {
            base.Initialize(requestContext);

            ViewBag.isAuth = User.Identity.IsAuthenticated;
            ViewBag.UserName = (User.Identity.IsAuthenticated) ? User.Identity.Name : "NoAuth";
        }

        protected string RequestUrl()
        {
            var request = Request.RequestContext.HttpContext.Items["MS_HttpRequestMessage"].ToString();

            var start = request.IndexOf(' ', request.IndexOf("Referer") + 1);
            var end = request.IndexOf('\r', start + 1);

            var u = request.Substring(start + 1, end - start - 1).Split(new char[] { '/' }, StringSplitOptions.RemoveEmptyEntries);

            string controller, action;
            if (u.Length > 3)
            {
                controller = u[2];
                action = u[3];
            }
            else
            {
                controller = "Home";
                action = "Index";
            }
            return '/' + controller + '/' + action;
        }

    }
}