﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace HyperGraph
{
    class Matrix<T>
    {
        public List<List<T>> matrix { get; }

        public int countRow { get; private set; }

        public int countColumn { get; private set; }

        public Matrix()
        {
            matrix = new List<List<T>>();
        }

        public Matrix(int count, bool isColumn = false)
        {
            matrix = new List<List<T>>();
            if (!isColumn)
            {
                countRow = 1;
                countColumn = count;
                matrix.Add(new List<T>());
                for (int i = 0; i < count; i++)
                    matrix[0].Add(default (T));                
            }
            else
            {
                countRow = count;
                countColumn = 1;
                for (int i = 0; i < count; i++)
                {
                    matrix.Add(new List<T>());
                    matrix[i].Add(default(T));
                }
            }
        }

        public Matrix(int countR0w, int countCol)
        {
            matrix = new List<List<T>>();
            countRow = countR0w;
            countColumn = countCol;
            for (int i = 0; i < countRow; i++)
            {
                matrix.Add(new List<T>());
                for (int j = 0; j < countColumn; j++)
                    matrix[i].Add(default(T));                
            }            
        }

        public bool AddRow()
        {
            try
            {
                countRow++;
                matrix.Add(new List<T>());
                int i = matrix.Count - 1;
                for (int j = 0; j < countColumn; j++)
                    matrix[i].Add(default(T));
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        public bool AddColumn()
        {
            try
            {
                countColumn++;
                for (int i = 0; i < countRow; i++)
                    matrix[i].Add(default(T));                 
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        // Индексатор
        public T this [int posRow, int posColumn]
        {
            get
            {
                try
                {
                    return matrix[posRow][posColumn];
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    return default(T);
                }
            }
            set
            {
                try
                {
                    matrix[posRow][posColumn] = value;
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);                   
                }
            }

        }
        /// <summary>
        /// Возвращает/Устанавливает List<typeparamref name="T"/>, содержащий строку (isColumn == false) или столбец (isColumn == true)
        /// </summary>
        /// <param name="pos">Номер обрабатываемого элемента</param>
        /// <param name="isColumn">Обрабатывать столбец (true) или строку (false)</param>
        /// <returns></returns>
        public List<T> this [int pos, bool isColumn = false]
        {
            get
            {
                try
                {
                    if (!isColumn)
                        return new List<T>(matrix[pos]);
                    else
                    {
                        List<T> result = new List<T>();
                        for (int i = 0; i < countRow; i++)
                            result.Add(matrix[i][pos]);
                        return result;
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    return null;
                }               
            }
            set
            {
                try
                {
                    if (!isColumn)
                        matrix[pos] = new List<T>(value);
                    else
                    {
                        List<T> input = new List<T>(value);
                        for (int i = 0; i < countRow; i++)
                            matrix[i][pos] = input[i];
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            }
        }
    }
}