using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;

namespace Common.WPF.Converters
{
	public class ColorToBrushConverter : IValueConverter
	{
		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			switch (value.ToString())
			{
				case "":
					return new SolidColorBrush(Colors.Crimson);
				case "":
					return new SolidColorBrush(Colors.Yellow);
				case "":
					return new SolidColorBrush(Colors.Green);
				case "":
					return new SolidColorBrush(Colors.SkyBlue);
				case "":
					return new SolidColorBrush(Colors.Blue);
				case "":
					return new SolidColorBrush(Colors.Violet);
				case "":
					return new SolidColorBrush(Colors.White);
				default:
                    if (value.ToString() != "")
                    {
                        return (SolidColorBrush)new BrushConverter().ConvertFrom(value.ToString());
                    }
                    return new SolidColorBrush(Colors.Black);
            }
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}
	}
}