﻿using Common.WPF;
//using WPF.Helpers;
using WPF.Model;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Visibility = System.Windows.Visibility;
using TheoremAuto = HyperGraphModel.Theorem.TheoremAuto;
using static WPF.Model.Calculate;

namespace WPF.ViewModel
{
    public class MainViewModel : ModifyViewModel
    {
        public MainViewModel() : base()
        {
            Verticies = new ObservableCollection<VertViewModel>();
            EnumTheorems = Enum.GetValues(typeof(EnumTheorem)).Cast<EnumTheorem>().ToList();
            SelectedTheorem = EnumTheorems.First();
            EdgesNum = 1;
            SameVertNum = 1;
            IsTheoremCorrect = false;
            AutomorphismCount = 0;

            CalculateCommand = new RelayCommand(OnCalculate);
            SaveResultCommand = new RelayCommand(OnSaveResult);

            //AddItemCommand = new RelayCommand<ItemViewModel>(OnAddItem, item => Items.FirstOrDefault(e => e.Value == item.Value) == null);
            //RemoveItemCommand = new RelayCommand<ItemViewModel>(OnRemoveItem, item => !item.Readonly);

            //SwitchDataVisibleCommand = new RelayCommand(OnSwitchDataVisible);
            //ClearSearchCommand = new RelayCommand(OnClearSearch);
        }

        #region Поля и свойства

        public static int MaxValue { get; } = 99;
        public static int MinValue { get; } = 0;

        public List<EnumTheorem> EnumTheorems { get; }

        private EnumTheorem _selectedTheorem;
        public EnumTheorem SelectedTheorem
        {
            set
            {
                _selectedTheorem = value;
                OnPropertyChanged(() => SelectedTheorem);
            }

            get => _selectedTheorem;
        }

        private int _edgesNum;
        public int EdgesNum
        {
            get => _edgesNum;
            set
            {
                _edgesNum = value;
                OnPropertyChanged(() => EdgesNum);
                UpdateVerticies();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        private int _sameVertNum;
        public int SameVertNum
        {
            get => _sameVertNum;
            set
            {
                _sameVertNum = value;
                OnPropertyChanged(() => SameVertNum);
                UpdateVerticiesValue();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        public Visibility VisibilityVerticies
        {
            get
            {
                return EdgesNum > 0 && SameVertNum > 0 ? Visibility.Visible : Visibility.Collapsed;
            }
        }

        public ObservableCollection<VertViewModel> Verticies { get; }

        public string TitleText { get => "Расчет гиперграфов"; }

        public string EdgesText { get => "Количество ребер"; }
        public string EdgesTextTooltip { get => "Подсказка. Количество ребер"; }

        public string SameVertText { get => "Количество общих вершин"; }
        public string SameVertTextTooltip { get => "Подсказка. Количество общих вершин"; }

        public string VerticiesText { get => "Номер ребра"; }
        public string VerticiesTextTooltip { get => "Подсказка. Номер ребра"; }

        public string VerticiesValueText { get => "Число вершин"; }
        public string VerticiesValueTooltip { get => "Подсказка. Число вершин в каждом ребре"; }

        public string TheoremOKText { get => "Удовлетворяет теореме"; }
        public string TheoremOKTooltip { get => "Подсказка. Удовлетворяет теореме"; }

        public string AutomorphismText { get => "Число автоморфизмов"; }
        public string AutomorphismTooltip { get => "Подсказка. Число автоморфизмов"; }

        private bool _isTheoremCorrect;
        public bool IsTheoremCorrect
        {
            get => _isTheoremCorrect;
            set
            {
                _isTheoremCorrect = value;
                OnPropertyChanged(() => IsTheoremCorrect);
            }
        }

        private long _automorphismCount;
        public long AutomorphismCount
        {
            get => _automorphismCount;
            set
            {
                _automorphismCount = value;
                OnPropertyChanged(() => AutomorphismCount);
            }
        }

        #endregion

        #region Методы и команды

        public void OnLoad()
        {
            //LoadData(App.DataFilePath);
            //LoadDataAsync(App.DataFilePath, true);
        }

        private void UpdateVerticies()
        {
            if (EdgesNum > Verticies.Count)
            {
                for (int i = Verticies.Count; i < EdgesNum; i++)
                    Verticies.Add(new VertViewModel(SameVertNum, (i + 1).ToString()));
            }
            else if (EdgesNum < Verticies.Count)
            {
                if (EdgesNum == 0)
                    Verticies.Clear();
                else
                {
                    var skip = Verticies.Skip(EdgesNum).ToList();
                    foreach (var vert in skip)
                    {
                        Verticies.Remove(vert);
                    }
                }
            }
        }

        private void UpdateVerticiesValue()
        {
            foreach (var vert in Verticies)
            {
                if (vert.Value < SameVertNum)
                    vert.Value = SameVertNum;
                vert.MinValue = SameVertNum;
            }
        }


        public RelayCommand CalculateCommand { get; }
        private void OnCalculate()
        {
            CreateGraph(EdgesNum, SameVertNum, Verticies.Select(x => x.Value).ToList());
            TheoremAuto result = default;
            switch (SelectedTheorem)
            {
                case EnumTheorem.Second:
                    {
                        result = TheoremSecond();
                        break;
                    }
                case EnumTheorem.Third:
                    {
                        result = TheoremThird();
                        break;
                    }
                case EnumTheorem.Forth:
                    {

                        break;
                    }
            }
            IsTheoremCorrect = result.isSatisfyTheorem;
            AutomorphismCount = result.CountAutomorphism;
        }

        public RelayCommand SaveResultCommand { get; }
        private void OnSaveResult()
        {

        }

        #endregion

    }

    public class VertViewModel : BaseViewModel
    {
        public VertViewModel(int startValue, string text)
        {
            Value = startValue;
            MinValue = startValue;
            VertText = text;
        }

        private int _value;
        public int Value
        {
            get => _value;
            set
            {
                _value = value;
                OnPropertyChanged(() => Value);
            }
        }

        private int _minValue;
        public int MinValue
        {
            get => _minValue;
            set
            {
                _minValue = value;
                OnPropertyChanged(() => MinValue);
            }
        }

        public string VertText { get; }
    }
}
