﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HyperGraph
{
    class HyperGraph
    {
        public List<List<string>> HyperEdge;

        public HyperGraph(Matrix<int> matrix)
        {
            HyperEdge = new List<List<string>>();

            //  По ребрам (столбцам)
            for (int j = 0; j < matrix.countColumn; j++)
            {
                HyperEdge.Add(new List<string>());
                //  По вершинам (строкам)
                for (int i = 0; i < matrix.countRow; i++)
                {
                    if (matrix[i][j] == 1)
                        HyperEdge[j].Add("v" + i);
                }
            }
        }

        //  Конструктор копирования
        public HyperGraph(HyperGraph graph)
        {
            HyperEdge = new List<List<string>>();                       

            foreach (var edge in graph.HyperEdge)
            {
                HyperEdge.Add(new List<string>());
                foreach (var elem in edge)
                    HyperEdge.Last().Add(elem);                
            }
        }

        //  При уничтожении
        ~HyperGraph()
        {
            this.Dispose();
        }

        //  Очистка памяти
        public void Dispose()
        {
            if (HyperEdge != null)
            {
                for (int i = 0; i < HyperEdge.Count; i++)
                    HyperEdge[i] = null;
                HyperEdge = null;
            }
            //  Так делать не хорошо. 
            //  Принудительный вызов сборщика мусора после удаления ссылок на списки данных.
            //  Очистит теперь неиспользуемую память.
            GC.Collect();
            GC.WaitForPendingFinalizers();
        }

        public override string ToString()
        {
            string fullString = "", edgeString;
            foreach (var edge in this.HyperEdge)
            {
                edgeString = "(";
                foreach (var vert in edge)
                    edgeString += vert + '-';
                fullString += edgeString.Remove(edgeString.Length - 1, 1) + ") ";
            }
            return fullString;
        }
    }
}
