﻿using Common.WPF;
using Common;
//using WPF.Helpers;
using WPF.Model;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.ComponentModel;
using System.Windows.Forms;
using Visibility = System.Windows.Visibility;
using TheoremAuto = HyperGraphModel.Theorem.TheoremAuto;
using static WPF.Model.Calculate;

namespace WPF.ViewModel
{
    public class MainViewModel : ModifyViewModel
    {
        public MainViewModel() : base()
        {
            Current = this;

            Verticies = new ObservableCollection<VertViewModel>();
            Verticies.NotifyPropertyChanged((obj, notifyPropertyChangedEventArgs) =>
            {
                SetResultDefault();
            });

            EnumTheorems = Enum.GetValues(typeof(EnumTheorem)).Cast<EnumTheorem>().ToList();
            SelectedTheorem = EnumTheorems.First();
            EdgesNum = 1;
            SameVertNum = 1;
            PathToSave = DefaultPathToSave;

            CalculateCommand = new RelayCommand(OnCalculate);
            SaveResultCommand = new RelayCommand(OnSaveResult, () => CanSave && IsTheoremCorrect);

            //AddItemCommand = new RelayCommand<ItemViewModel>(OnAddItem, item => Items.FirstOrDefault(e => e.Value == item.Value) == null);
            //RemoveItemCommand = new RelayCommand<ItemViewModel>(OnRemoveItem, item => !item.Readonly);

            //SwitchDataVisibleCommand = new RelayCommand(OnSwitchDataVisible);
            //ClearSearchCommand = new RelayCommand(OnClearSearch);

#if DEBUG
            //EdgesNum = 6;
            //SameVertNum = 2;
            //Verticies[0].Value = 4;
            //Verticies[1].Value = 5;
            //Verticies[2].Value = 6;
            //Verticies[3].Value = 6;
            //Verticies[4].Value = 2;
            //Verticies[5].Value = 7;
            EdgesNum = 4;
            SameVertNum = 1;
            Verticies[0].Value = 4;
            Verticies[1].Value = 4;
            Verticies[2].Value = 4;
            Verticies[3].Value = 4;
            SelectedTheorem = EnumTheorem.Fifth;
#endif
        }

        #region Поля и свойства

        public static MainViewModel Current { get; private set; }

        private readonly string DefaultPathToSave = $"C:\\Users\\{Environment.UserName}\\Documents\\";
        private string PathToSave { get; set; }

        public static int MaxValue { get; } = 99;
        public static int MinValue { get; } = 0;

        public List<EnumTheorem> EnumTheorems { get; }

        private EnumTheorem _selectedTheorem;
        public EnumTheorem SelectedTheorem
        {
            set
            {
                _selectedTheorem = value;
                SetResultDefault();
                UpdateText();
                OnPropertyChanged(() => SelectedTheorem);
            }

            get => _selectedTheorem;
        }

        private bool _canSave;
        public bool CanSave
        {
            get => _canSave;
            set
            {
                _canSave = value;
                OnPropertyChanged(() => CanSave);
            }
        }

        private int _edgesNum;
        public int EdgesNum
        {
            get => _edgesNum;
            set
            {
                _edgesNum = value;
                SetResultDefault();
                OnPropertyChanged(() => EdgesNum);
                UpdateVerticies();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        private int _sameVertNum;
        public int SameVertNum
        {
            get => _sameVertNum;
            set
            {
                _sameVertNum = value;
                SetResultDefault();
                OnPropertyChanged(() => SameVertNum);
                UpdateVerticiesValue();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        public Visibility VisibilityVerticies
        {
            get
            {
                return EdgesNum > 0 && SameVertNum > 0 ? Visibility.Visible : Visibility.Collapsed;
            }
        }

        public ObservableCollection<VertViewModel> Verticies { get; }

        public string TitleText { get => "Расчет гиперграфов"; }

        public string EdgesText { get => "Количество ребер"; }
        public string EdgesTextTooltip { get => "Подсказка. Количество ребер"; }

        private string _sameVertText;
        public string SameVertText 
        { 
            get => _sameVertText;
            set
            {
                _sameVertText = value;
                OnPropertyChanged(() => SameVertText);
            }
        }
        private string _sameVertTextTooltip;
        public string SameVertTextTooltip
        {
            get => _sameVertTextTooltip;
            set
            {
                _sameVertTextTooltip = value;
                OnPropertyChanged(() => SameVertTextTooltip);
            }
        }

        public string VerticiesText { get => "Номер ребра"; }
        public string VerticiesTextTooltip { get => "Подсказка. Номер ребра"; }

        public string VerticiesValueText { get => "Число вершин"; }
        public string VerticiesValueTooltip { get => "Подсказка. Число вершин в каждом ребре"; }

        public string TheoremOKText { get => "Удовлетворяет теореме"; }
        public string TheoremOKTooltip { get => "Подсказка. Удовлетворяет теореме"; }

        public string AutomorphismText { get => "Число автоморфизмов"; }
        public string AutomorphismTooltip { get => "Подсказка. Число автоморфизмов"; }

        private bool _isTheoremCorrect;
        public bool IsTheoremCorrect
        {
            get => _isTheoremCorrect;
            set
            {
                _isTheoremCorrect = value;
                OnPropertyChanged(() => IsTheoremCorrect);
            }
        }

        private long _automorphismCount;
        public long AutomorphismCount
        {
            get => _automorphismCount;
            set
            {
                _automorphismCount = value;
                OnPropertyChanged(() => AutomorphismCount);
            }
        }

        private TheoremAuto _result;
        public TheoremAuto Result
        {
            get => _result;
            set
            {
                _result = value;
                IsTheoremCorrect = value.isSatisfyTheorem;
                AutomorphismCount = value.CountAutomorphism;
                OnPropertyChanged(() => Result);
            }
        }

        private Status _status;
        public Status Status
        {
            get { return _status; }
            set
            {
                _status = value;
                OnPropertyChanged(() => Status);
            }
        }

        private string _statusMessage;
        public string StatusMessage
        {
            get { return _statusMessage; }
            set
            {
                _statusMessage = value;
                OnPropertyChanged(() => StatusMessage);
            }
        }

        #endregion

        #region Методы и команды

        public void OnLoad()
        {
            //LoadData(App.DataFilePath);
            //LoadDataAsync(App.DataFilePath, true);
        }

        private void UpdateText()
        {
            switch(SelectedTheorem)
            {
                case EnumTheorem.Second:
                case EnumTheorem.Third:
                    {
                        CanSave = true;
                        SameVertText = "Количество общих вершин";
                        SameVertTextTooltip = "Подсказка. Количество общих вершин";
                        break;
                    }
                case EnumTheorem.Forth:
                case EnumTheorem.Fifth:
                    {
                        CanSave = false;
                        SameVertText = "Количество пересекающихся вершин";
                        SameVertTextTooltip = "Подсказка. Количество вершин, являющихся общими между соседними ребрами";
                        break;
                    }
            }
        }

        private void UpdateVerticies()
        {
            if (EdgesNum > Verticies.Count)
            {
                for (int i = Verticies.Count; i < EdgesNum; i++)
                    Verticies.Add(new VertViewModel(SameVertNum, (i + 1).ToString()));
            }
            else if (EdgesNum < Verticies.Count)
            {
                var skip = Verticies.Skip(EdgesNum).ToList();
                foreach (var vert in skip)
                {
                    Verticies.Remove(vert);
                }
            }
        }

        private void UpdateVerticiesValue()
        {
            foreach (var vert in Verticies)
            {
                if (vert.Value < SameVertNum)
                    vert.Value = SameVertNum;
                vert.MinValue = SameVertNum;
            }
        }

        public RelayCommand CalculateCommand { get; }
        private void OnCalculate()
        {
            CreateGraph(EdgesNum, SameVertNum, Verticies.Select(x => x.Value).ToList(), SelectedTheorem);
            SetResultDefault();
            switch (SelectedTheorem)
            {
                case EnumTheorem.Second:
                    {
                        Result = TheoremSecond();
                        Status = Status.OperationSuccess;
                        StatusMessage = "Расчет успешно выполнен";

                        if (!Result.isSatisfyTheorem && Graph.IsEqualNumberOfVertices)
                        {
                            Status = Status.SpecialWarning;
                            StatusMessage = "Расчет успешно выполнен. Используйте теорему три";
                        }
                        break;
                    }
                case EnumTheorem.Third:
                    {
                        Result = TheoremThird();
                        Status = Status.OperationSuccess;
                        StatusMessage = "Расчет успешно выполнен";

                        if (!Result.isSatisfyTheorem && !Graph.IsEqualNumberOfVertices)
                        {
                            Status = Status.SpecialWarning;
                            StatusMessage = "Расчет успешно выполнен. Используйте теорему два";
                        }
                        break;
                    }
                case EnumTheorem.Forth:
                    {
                        Result = TheoremForth();
                        Status = Status.OperationSuccess;
                        StatusMessage = "Расчет успешно выполнен";

                        if (!Result.isSatisfyTheorem && Graph.IsEqualNumberOfVertices)
                        {
                            Status = Status.SpecialWarning;
                            StatusMessage = "Расчет успешно выполнен. Используйте теорему пять";
                        }
                        break;
                    }
                case EnumTheorem.Fifth:
                    {
                        Result = TheoremFifth();
                        Status = Status.OperationSuccess;
                        StatusMessage = "Расчет успешно выполнен";

                        if (!Result.isSatisfyTheorem && !Graph.IsEqualNumberOfVertices)
                        {
                            Status = Status.SpecialWarning;
                            StatusMessage = "Расчет успешно выполнен. Используйте теорему четыре";
                        }
                        break;
                    }
            }
        }

        public RelayCommand SaveResultCommand { get; }
        private void OnSaveResult()
        {
            if (!Directory.Exists(PathToSave))
                PathToSave = DefaultPathToSave;

            var streamResult = Export(Result, SelectedTheorem);

            if (streamResult.CanRead && streamResult.Length == 0)
            {
                Status = Status.Error;
                StatusMessage = "Ошибка экспорта. Поток экспорта пустой.";
                streamResult.Close();
                return;
            }

            using (SaveFileDialog saveFileDialog = new SaveFileDialog()
            {
                Filter = "Text file (*.txt)|*.txt",/*"Text file (*.txt)|*.txt|C# file (*.cs)|*.cs",*/
                InitialDirectory = PathToSave
            })
            {
                if (saveFileDialog.ShowDialog() == DialogResult.OK)
                {
                    PathToSave = Path.GetDirectoryName(saveFileDialog.FileName);
                    File.WriteAllBytes(saveFileDialog.FileName, streamResult.ToArray());

                    Status = Status.OperationSuccess;
                    StatusMessage = $"Файл успешно сохранен: {saveFileDialog.FileName}";
                }
            }

        }

        private void SetResultDefault()
        {
            Result = default;
            Status = Status.Default;
            StatusMessage = "Результат успешно сброшен";
        }

        #endregion

    }

    public class VertViewModel : BaseViewModel
    {
        public VertViewModel(int startValue, string text)
        {
            Value = startValue;
            MinValue = startValue;
            VertText = text;
        }

        private int _value;
        public int Value
        {
            get => _value;
            set
            {
                _value = value;
                OnPropertyChanged(() => Value);
            }
        }

        private int _minValue;
        public int MinValue
        {
            get => _minValue;
            set
            {
                _minValue = value;
                OnPropertyChanged(() => MinValue);
            }
        }

        public string VertText { get; }
    }
}
