﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HyperGraph
{
    static class Combinatorics<T>
    {
        /// <summary>
        /// Множество перестановок (без повторения) элементов входящего множества
        /// </summary>
        /// <param name="array">Входящее множество</param>
        /// <returns></returns>
        public static List<List<T>> Transposition(List<T> array)
        {
            List<List<T>> result = new List<List<T>>();

            int[] temp = new int[array.Count];
            int n = array.Count;
            for (int i = 0; i < n; i++)
                temp[i] = i + 1;

            while (true)
            {
                int j = n - 2;
                while (j != -1 && temp[j] >= temp[j + 1])
                    j--;
                if (j == -1)
                    break;

                int k = n - 1;
                while (temp[j] >= temp[k]) k--;

                Swap(ref temp[j], ref temp[k]);
                int l = j + 1, r = n - 1;
                while (l < r)
                    Swap(ref temp[l++], ref temp[r--]);
                result.Add(AddInOrderFromList(array, temp));
            }

            return result;
        }
        /// <summary>
        /// Создает новый массив (лист) типа Т, со значениями в порядке массива order
        /// </summary>
        /// <param name="list">Лист значений</param>
        /// <param name="order">Массив порядка значений</param>
        /// <returns></returns>
        private static List<T> AddInOrderFromList(List<T> list, int[] order)
        {
            List<T> temp = null;

            try
            {
                temp = new List<T>();
                for (int i = 0; i < order.Length; i++)
                    temp.Add(list[order[i] - 1]);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
            return temp;
        }

        private static bool Swap<t>(ref t a, ref t b)
        {
            try
            {
                t temp = a;
                a = b;
                b = temp;
            }
            catch (Exception e )
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

    }
}
