﻿using Common.WPF;
//using WPF.Helpers;
using WPF.Model;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Visibility = System.Windows.Visibility;

namespace WPF.ViewModel
{
    public class MainViewModel : ModifyViewModel
    {
        public MainViewModel() : base()
        {
            //Items = new ObservableCollection<ItemViewModel>();
            //System.Windows.Data.BindingOperations.EnableCollectionSynchronization(Items, _lock);
            //CreatePanel = new CreatingViewModel(this);
            //IsAllDataHide = true;

            Verticies = new ObservableCollection<VertViewModel>();
            EnumTheorems = Enum.GetValues(typeof(EnumTheorem)).Cast<EnumTheorem>().ToList();
            SelectedTheorem = EnumTheorems.First();

            //AddItemCommand = new RelayCommand<ItemViewModel>(OnAddItem, item => Items.FirstOrDefault(e => e.Value == item.Value) == null);
            //RemoveItemCommand = new RelayCommand<ItemViewModel>(OnRemoveItem, item => !item.Readonly);
            //OpenFileCommand = new RelayCommand(OnOpenFile);
            //SwitchDataVisibleCommand = new RelayCommand(OnSwitchDataVisible);
            //ClearSearchCommand = new RelayCommand(OnClearSearch);
        }

        #region Поля и свойства

        public static int MaxValue { get; } = 99;
        public static int MinValue { get; } = 0;

        public List<EnumTheorem> EnumTheorems { get; }

        private EnumTheorem _selectedTheorem;
        public EnumTheorem SelectedTheorem
        {
            set
            {
                _selectedTheorem = value;
                OnPropertyChanged(() => SelectedTheorem);
                // do smth
            }

            get => _selectedTheorem;
        }

        private decimal _edgesNum;
        public decimal EdgesNum
        {
            get => _edgesNum;
            set
            {
                _edgesNum = value;
                OnPropertyChanged(() => EdgesNum);
                UpdateVerticies();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        private decimal _sameVertNum;
        public decimal SameVertNum
        {
            get => _sameVertNum;
            set
            {
                _sameVertNum = value;
                OnPropertyChanged(() => SameVertNum);
                UpdateVerticiesValue();
                OnPropertyChanged(() => VisibilityVerticies);
            }
        }

        public Visibility VisibilityVerticies
        {
            get
            {
                return EdgesNum > 0 && SameVertNum > 0 ? Visibility.Visible : Visibility.Collapsed;
            }
        }

        public ObservableCollection<VertViewModel> Verticies { get; }

        public string EdgesText { get => "Количество ребер"; }
        public string EdgesTextTooltip { get => "Подсказка. Количество ребер"; }

        public string SameVertText { get => "Количество общих вершин"; }
        public string SameVertTextTooltip { get => "Подсказка. Количество общих вершин"; }

        public string VerticiesText { get => "Номер ребра"; }
        public string VerticiesTextTooltip { get => "Подсказка. Номер ребра"; }

        public string VerticiesValueText { get => "Число вершин"; }
        public string VerticiesValueTooltip { get => "Подсказка. Число вершин в каждом ребре"; }
        public string TitleText { get => "Расчет гиперграфов"; }

        #endregion

        #region Методы и команды

        public void OnLoad()
        {
            //LoadData(App.DataFilePath);
            //LoadDataAsync(App.DataFilePath, true);
        }

        private void UpdateVerticies()
        {
            if (EdgesNum > Verticies.Count)
            {
                for (int i = Verticies.Count; i < EdgesNum; i++)
                    Verticies.Add(new VertViewModel(SameVertNum, (i + 1).ToString()));
            }
            else if (EdgesNum < Verticies.Count)
            {
                if (EdgesNum == 0)
                    Verticies.Clear();
                else
                {
                    var skip = Verticies.Skip((int)EdgesNum).ToList();
                    foreach (var vert in skip)
                    {
                        Verticies.Remove(vert);
                    }
                }
            }
        }

        private void UpdateVerticiesValue()
        {
            foreach (var vert in Verticies)
            {
                if (vert.Value < SameVertNum)
                    vert.Value = SameVertNum;
                vert.MinValue = SameVertNum;
            }
        }

        #endregion

    }

    public class VertViewModel : BaseViewModel
    {
        public VertViewModel(decimal startValue, string text)
        {
            Value = startValue;
            MinValue = startValue;
            VertText = text;
        }

        private decimal _value;
        public decimal Value
        {
            get => _value;
            set
            {
                _value = value;
                OnPropertyChanged(() => Value);
            }
        }

        private decimal _minValue;
        public decimal MinValue
        {
            get => _minValue;
            set
            {
                _minValue = value;
                OnPropertyChanged(() => MinValue);
            }
        }

        public string VertText { get; }
    }
}
