﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HyperGraph
{
    class Program
    {
        /* 6 7
        0 0 1 0 1 0 0
        0 0 0 0 0 1 0
        1 1 1 0 0 0 0
        0 0 0 1 0 1 1
        0 1 1 1 0 0 0
        0 0 0 0 1 0 1
        */

        /* 11 3
        1 1 1
        1 0 0
        1 0 0
        1 0 0
        0 1 0
        0 1 0
        0 1 0
        0 1 0
        0 0 1
        0 0 1
        1 1 1
        */

        static void Main(string[] args)
        {
            Matrix<int> u = new Matrix<int>(4);

            System.IO.StreamReader input = new System.IO.StreamReader("D:\\input.txt");
            System.IO.StreamWriter output = new System.IO.StreamWriter("D:\\output.txt");

            //  Экземпляр гипер-графа, созданный на основе загружаемой матрицы инцидентности
            //  11 - кол-во строк, 3 - кол-во столбцов
            HyperGraph graph = new HyperGraph(Matrix<int>.LoadFromStream(input, 11, 3));


            //  Все перестановки гипер-графа
            //ExampleAllTranspos(graph, input, output);

            //  Вычислить количество автоморфизмов графа и вывести перестановки
            ExampleTheorema(graph, output);

            input.Close(); output.Close();
            Console.WriteLine("Completed. Press any key");
            Console.ReadKey();
        }

        //  Все перестановки графа вывести в файл
        static void ExampleAllTranspos(HyperGraph graph, System.IO.StreamWriter output)
        {
            //  Массив (лист) всех возможных перестановок одного множества (гипер-ребра)
            List<List<string>> transpos;

            //  Обработать все гипер-ребра
            for (int i = 0; i < graph.HyperEdge.Count; i++)
            {
                //  Получить массив перестановок текущего гипер-ребра
                transpos = Combinatorics<string>.Transposition(graph.HyperEdge[i]);

                // Вывод всех вершин текущего гипер-ребра 
                output.Write("Current edge include:");
                for (int g = 0; g < graph.HyperEdge[i].Count; g++)
                    output.Write(" {0}", graph.HyperEdge[i][g]);

                //  Вывод всех перестановок текущего гипер-ребра
                output.WriteLine();

                //  Вывод начальной перестановки
                output.Write("1:");
                for (int g = 0; g < graph.HyperEdge[i].Count; g++)
                    output.Write(" {0}", graph.HyperEdge[i][g]);
                output.WriteLine("\n\t-----------");
                //  Алгоритм перестановок не учитывает начальную, а начинает со следующей
                for (int g = 0; g < transpos.Count; g++)
                {
                    output.Write("{0}: ", g + 2);
                    for (int f = 0; f < transpos[g].Count; f++)
                        output.Write("{0} ", transpos[g][f]);
                    output.WriteLine("\n\t-----------");
                }
                output.WriteLine();
            }
        }

        //  Найти общие вершины для всех гипер-ребер, подсчитать количество автоморфизмов гипер-графа и вывести все перестановки оставшихся ребер
        static void ExampleTheorema(HyperGraph graph, System.IO.StreamWriter output)
        {
            //  Получить результат вычислений
            var result = Theorem.TheoremAutomorphism(graph);
            //  Выполняется ли условие согласно теореме 2
            Console.WriteLine("Is Thereom 2: " + result.isSatisfyTheorem);
            if (result.isSatisfyTheorem)
            {
                //  Вывод числа автоморфизмов в консоль
                Console.WriteLine("Count of automorphism: " + result.CountAutomorphism);
            }
            //  Выполняется ли условие согласно теореме 2
            output.WriteLine("Is Thereom 2: " + result.isSatisfyTheorem);
            //  Если да, то вывести
            if (result.isSatisfyTheorem)
            {
                //  Вывод вершин и числа автоморфизмов в файл
                output.WriteLine("Automorphism with nodes: ");
                foreach (var node in result.AutomorphismNodes)
                    output.Write(node + " ");
                output.WriteLine();
                //  Вывод всех перестановок общих вершин
                List<List<string>> transpos = Combinatorics<string>.Transposition(result.AutomorphismNodes);
                //  Вывод начальной перестановки
                output.Write("1:");
                for (int g = 0; g < result.AutomorphismNodes.Count; g++)
                    output.Write(" {0}", result.AutomorphismNodes[g]);
                output.WriteLine("\n\t-----------");
                //  Алгоритм перестановок не учитывает начальную, а начинает со следующей
                for (int g = 0; g < transpos.Count; g++)
                {
                    output.Write("{0}: ", g + 2);
                    for (int f = 0; f < transpos[g].Count; f++)
                        output.Write("{0} ", transpos[g][f]);
                    output.WriteLine("\n\t-----------");
                }                

                output.WriteLine("\nCount of automorphism: " + result.CountAutomorphism + "\n");

                //  Вывести перестановки в файл
                ExampleAllTranspos(result.GraphWithoutAutoEdges, output);
                output.Write("Automorphism with nodes: ");                

            }
            //  Уничтожить временный граф
            result.GraphWithoutAutoEdges.Dispose();
        }
    }
}
