﻿using WPF.ViewModel;
using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace WPF.View
{
    /// <summary>
    /// Логика взаимодействия для MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            DataContext = new MainViewModel();
            Application.Current.Dispatcher.BeginInvoke(
                System.Windows.Threading.DispatcherPriority.ApplicationIdle,
                new Action(() =>
                {
                    (DataContext as MainViewModel).OnLoad();
                }));
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            var myHeaderGrid = (Grid)this.FindName("Header");
            if (myHeaderGrid != null)
            {
                myHeaderGrid.MouseLeftButtonDown += OnMouseDown;
            }
        }

        private void OnMouseDown(object sender, MouseButtonEventArgs e)
        {
            if (e.ChangedButton == MouseButton.Left)
            {
                DragMove();
            }
        }

        private void textBox_DoubleInput(object sender, TextCompositionEventArgs e)
        {
            TextBox thisTextBox = (sender as TextBox);
            e.Handled =
                (!(char.IsDigit(e.Text, 0) /*&& !((thisTextBox.Text.IndexOf("-") == 0) && thisTextBox.SelectionStart == 0)*/ )) &&
                //((e.Text.Substring(0, 1) != "-") || (thisTextBox.Text.IndexOf("-") == 0) || thisTextBox.SelectionStart != 0) &&
                ((e.Text.Substring(0, 1) != ".") || (thisTextBox.Text.IndexOf(".") != -1) || (thisTextBox.SelectionStart == 0) || (!char.IsDigit(thisTextBox.Text.Substring(thisTextBox.SelectionStart - 1, 1), 0)) || ((thisTextBox.Text.IndexOf(",") != -1))) &&
                ((e.Text.Substring(0, 1) != ",") || (thisTextBox.Text.IndexOf(",") != -1) || (thisTextBox.SelectionStart == 0) || (!char.IsDigit(thisTextBox.Text.Substring(thisTextBox.SelectionStart - 1, 1), 0)) || ((thisTextBox.Text.IndexOf(".") != -1)));
        }
        private void textBox_IntInput(object sender, TextCompositionEventArgs e)
        {
            TextBox thisTextBox = (sender as TextBox);
            e.Handled = (!(char.IsNumber(e.Text, 0)));
        }

        private void TextBox_LostFocus(object sender, RoutedEventArgs e)
        {
            if (sender is TextBox textBox)
            {
                if (string.IsNullOrEmpty(textBox.Text))
                {
                    textBox.Text = "0";
                    return;
                }
                if (double.TryParse(textBox.Text.Replace(',', '.'), System.Globalization.NumberStyles.Number, System.Globalization.CultureInfo.InvariantCulture, out double res))
                {
                    if (res < 0)
                        textBox.Text = "0";
                }
                else
                {
                    textBox.Text = "0";
                }
            }
        }

        private bool isFocused = false;
        private void TextBox_GotFocus(object sender, RoutedEventArgs e)
        {
            isFocused = true;
        }

        private void TextBox_SelectionChanged(object sender, RoutedEventArgs e)
        {
            if (isFocused)
            {
                isFocused = false;
                (sender as TextBox).SelectAll();
            }
        }
    }
}
