﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HyperGraph
{
    class Program
    {
        /* 6 7
        0 0 1 0 1 0 0
        0 0 0 0 0 1 0
        1 1 1 0 0 0 0
        0 0 0 1 0 1 1
        0 1 1 1 0 0 0
        0 0 0 0 1 0 1
        */

        static void Main(string[] args)
        {            
            System.IO.StreamReader input = new System.IO.StreamReader("D:\\input.txt");
            System.IO.StreamWriter output = new System.IO.StreamWriter("D:\\output.txt");

            //  Экземпляр гипер-графа, созданный на основе загружаемой матрицы инцидентности
            //  6 - кол-во строк, 7 - кол-во столбцов
            HyperGraph graph = new HyperGraph(Matrix<int>.LoadFromStream(input, 6, 7));

            //  Массив (лист) всех возможных перестановок одного множества (гипер-ребра)
            List<List<string>> transpos;

            //  Обработать все гипер-ребра
            for (int i = 0; i < graph.HyperEdge.Count; i++)
            {
                //  Получить массив перестановок текущего гипер-ребра
                transpos = Combinatorics<string>.Transposition(graph.HyperEdge[i]);

                // Вывод всех вершин текущего гипер-ребра 
                output.Write("Current edge include:");
                for (int g = 0; g < graph.HyperEdge[i].Count; g++)
                    output.Write(" {0}", graph.HyperEdge[i][g]);

                //  Вывод всех перестановок текущего гипер-ребра
                output.WriteLine();

                //  Вывод начальной перестановки
                output.Write("1:");
                for (int g = 0; g < graph.HyperEdge[i].Count; g++)
                    output.Write(" {0}", graph.HyperEdge[i][g]);
                output.WriteLine("\n\t-----------");
                //  Алгоритм перестановок не учитывает начальную, а начинает со следующей
                for (int g = 0; g < transpos.Count; g++)
                {
                    output.Write("{0}: ", g+2);
                    for (int f = 0; f < transpos[g].Count; f++)
                        output.Write("{0} ", transpos[g][f]);
                    output.WriteLine("\n\t-----------");
                }
                output.WriteLine();
            }

            input.Close(); output.Close();
            Console.WriteLine("Completed. Press any key");
            Console.ReadKey();
        }
    }
}
