﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace HyperGraph
{
    class Matrix<T>
    {
        public List<List<T>> matrix { get; }

        public int countRow { get; private set; }

        public int countColumn { get; private set; }

        public Matrix()
        {
            matrix = new List<List<T>>();
        }

        public Matrix(int count, bool isColumn = false)
        {
            matrix = new List<List<T>>();
            if (!isColumn)
            {
                countRow = 1;
                countColumn = count;
                matrix.Add(new List<T>());
                for (int i = 0; i < count; i++)
                    matrix[0].Add(default (T));                
            }
            else
            {
                countRow = count;
                countColumn = 1;
                for (int i = 0; i < count; i++)
                {
                    matrix.Add(new List<T>());
                    matrix[i].Add(default(T));
                }
            }
        }

        public Matrix(int countR0w, int countCol)
        {
            matrix = new List<List<T>>();
            countRow = countR0w;
            countColumn = countCol;
            for (int i = 0; i < countRow; i++)
            {
                matrix.Add(new List<T>());
                for (int j = 0; j < countColumn; j++)
                    matrix[i].Add(default(T));                
            }            
        }

        public bool AddRow()
        {
            try
            {
                countRow++;
                matrix.Add(new List<T>());
                int i = matrix.Count - 1;
                for (int j = 0; j < countColumn; j++)
                    matrix[i].Add(default(T));
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        public bool AddColumn()
        {
            try
            {
                countColumn++;
                for (int i = 0; i < countRow; i++)
                    matrix[i].Add(default(T));                 
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        // Индексатор
        public T this [int posRow, int posColumn]
        {
            get
            {
                try
                {
                    return matrix[posRow][posColumn];
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    return default(T);
                }
            }
            set
            {
                try
                {
                    this.matrix[posRow][posColumn] = value;
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);                   
                }
            }

        }
        /// <summary>
        /// Возвращает/Устанавливает List<typeparamref name="T"/>, содержащий строку (isColumn == false) или столбец (isColumn == true)
        /// </summary>
        /// <param name="pos">Номер обрабатываемого элемента</param>
        /// <param name="isColumn">Обрабатывать столбец (true) или строку (false)</param>
        /// <returns></returns>
        public List<T> this [int pos, bool isColumn = false]
        {
            get
            {
                try
                {
                    if (!isColumn)
                        return new List<T>(matrix[pos]);
                    else
                    {
                        List<T> result = new List<T>();
                        for (int i = 0; i < countRow; i++)
                            result.Add(matrix[i][pos]);
                        return result;
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    return null;
                }               
            }
            set
            {
                try
                {
                    if (!isColumn)
                        matrix[pos] = new List<T>(value);
                    else
                    {
                        List<T> input = new List<T>(value);
                        for (int i = 0; i < countRow; i++)
                            matrix[i][pos] = input[i];
                    }
                }
                catch (Exception e)
                {
                    
                }
            }
        }

        static t ConvertValue<t, U>(U value) where U : IConvertible
        {
            return (t)Convert.ChangeType(value, typeof(t));
        }

        public static Matrix<T> LoadFromStream(System.IO.StreamReader input)
        {
            Matrix<T> matrix = new Matrix<T>(0, 0);
            int countCol;
            string r0w;
            try
            {
                //  Поток существует?
                if (input == null)
                    throw new Exception();
                //  Позиция чтения с начала файла
                input.BaseStream.Position = 0;
                //  Получаем первую строку, чтобы узнать количество столбцов
                r0w = input.ReadLine();
                string[] temp = r0w.Split(' ');
                countCol = temp.Length;

                //  Пересоздаем матрицу, т.к. получили количество столбцов
                matrix = new Matrix<T>(1, countCol);

                //  Заполнение первой строки
                for (int j = 0; j < countCol; j++)
                {
                    T tmp = ConvertValue<T, string>(temp[j]);
                    matrix[0, j] = tmp;
                }
                
                //  Перебираем все оставшиеся строки
                while(!input.EndOfStream)
                {
                    r0w = input.ReadLine();
                    temp = r0w.Split(' ');
                    //  Добавление новой строки в матрицу
                    matrix.AddRow();
                    for (int j = 0; j < countCol; j++)
                    {
                        T tmp = ConvertValue<T, string>(temp[j]);
                        matrix[matrix.countRow - 1, j] = tmp;
                    }
                }               
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
            
            return matrix;
        }

        public static bool UnloadToStream(Matrix<T> matrix, System.IO.StreamWriter output)
        {
            try
            {
                if (output == null)
                    throw new Exception();
                for (int i = 0; i < matrix.countRow; i++)
                {
                    for (int j = 0; j < matrix.countColumn; j++)
                    {
                        output.Write(matrix[i][j] + " ");
                    }
                    output.WriteLine();
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }
    }
}