﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Microsoft.AspNet.SignalR;

using System.Threading.Tasks;
using SignaIR_Test.Models.Chat;
using Microsoft.AspNet.SignalR.Hubs;

namespace SignaIR_Test.Hubs
{
    [HubName("SignalR_Hub")]
    public class SignalR_Hub : Hub
    {
        static List<UserEntity> Users = new List<UserEntity>();
        static List<MessageEntity> Messages = new List<MessageEntity>();

        // Отправка сообщений
        public void Send(string name, string message)
        {
            var msg = new MessageEntity()
            {
                name = name,
                message = message
            };

            Messages.Add(msg);

            Clients.All.addMessage(msg.name, msg.message_WithDateTime);
        }

        // Подключение нового пользователя
        public void Connect(string userName)
        {
            var id = Context.ConnectionId;


            if (!Users.Any(x => x.ConnectionId == id))
            {
                Users.Add(new UserEntity { ConnectionId = id, Name = userName });

                // Посылаем данные пользователю
                Clients.Caller.onConnected(id, userName, Users);

                // Посылаем сообщение всем пользователям, кроме текущего
                Clients.AllExcept(id).onNewUserConnected(id, userName);


                if (Messages.Count != 0)
                {
                    //Отправить новому пользователю историю сообщений
                    foreach (var elem in Messages)
                    {
                        Clients.Caller.addMessage(elem.name, elem.message_WithDateTime);
                    }

                    Clients.Caller.ShowAlert(string.Format("Все сообщения загружены ({0})", Messages.Count));
                }
                else
                {
                    Clients.Caller.ShowAlert("Сообщений нет");
                }

            }
        }

        // Отключение пользователя
        public override Task OnDisconnected(bool stopCalled)
        {
            var item = Users.FirstOrDefault(x => x.ConnectionId == Context.ConnectionId);
            if (item != null)
            {
                Users.Remove(item);
                var id = Context.ConnectionId;
                Clients.All.onUserDisconnected(id, item.Name);
            }

            return base.OnDisconnected(stopCalled);
        }
    }
}